/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.init;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.IModTileEntity;
import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.init.RegisterModObject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="enderio")
public class ModObjectRegistry {
    @Nonnull
    private static final ResourceLocation NAME = new ResourceLocation("enderio", "modobject");
    private static IForgeRegistry<IModObject> REGISTRY = null;
    private static final Map<Object, IModObject> reverseMapping = new IdentityHashMap<Object, IModObject>();
    private static final NNList<IModTileEntity> tileEntities = new NNList();

    @SubscribeEvent
    public static void registerRegistry(@Nonnull RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(NAME).setType(IModObject.class).setIDRange(0, 0xFFFFFF).create();
    }

    @SubscribeEvent
    public static void registerRegistry(@Nonnull EnderIOLifecycleEvent.PreInit event) {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterModObject(NAME, (IForgeRegistry<IModObject>)((IForgeRegistry)NullHelper.notnullF(REGISTRY, (String)"RegistryBuilder.create()"))));
    }

    public static <T extends Enum<T>> void addModTileEntities(Class<T> enumClass) {
        tileEntities.addAll(Arrays.asList(enumClass.getEnumConstants()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerBlocksEarly(@Nonnull RegisterModObject event) {
        event.register(ModObject.class);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        for (IModObject mo : REGISTRY) {
            String blockMethodName = mo.getBlockMethodName();
            if (blockMethodName == null) continue;
            ModObjectRegistry.createBlock(mo, blockMethodName, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerAddonBlocks(@Nonnull RegistryEvent.Register<Block> event) {
        for (ModContainer modContainer : Loader.instance().getModList()) {
            Object mod = modContainer.getMod();
            if (!(mod instanceof IEnderIOAddon)) continue;
            ((IEnderIOAddon)mod).injectBlocks((IForgeRegistry<Block>)((IForgeRegistry)NullHelper.notnullF((Object)event.getRegistry(), (String)"RegistryEvent.Register<Block>.getRegistry()")));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerTileEntities(@Nonnull RegistryEvent.Register<Block> event) {
        ModObjectRegistry.registerTeClasses();
    }

    @SubscribeEvent
    public static void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        for (IModObject mo : REGISTRY) {
            String itemMethodName = mo.getItemMethodName();
            if (itemMethodName != null) {
                ModObjectRegistry.createItem(mo, itemMethodName, event);
                continue;
            }
            ModObjectRegistry.createBlockItem(mo, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerOredict(@Nonnull RegistryEvent.Register<Item> event) {
    }

    public static void init(@Nonnull FMLInitializationEvent event) {
        for (IModObject mo : REGISTRY) {
            Item item;
            Block block = mo.getBlock();
            if (block instanceof IModObject.LifecycleInit) {
                ((IModObject.LifecycleInit)block).init(mo, event);
            }
            if (!((item = mo.getItem()) instanceof IModObject.LifecycleInit)) continue;
            ((IModObject.LifecycleInit)item).init(mo, event);
        }
    }

    public static void init(@Nonnull FMLPostInitializationEvent event) {
        for (IModObject mo : REGISTRY) {
            Item item;
            Block block = mo.getBlock();
            if (block instanceof IModObject.LifecyclePostInit) {
                ((IModObject.LifecyclePostInit)block).init(mo, event);
            }
            if (!((item = mo.getItem()) instanceof IModObject.LifecyclePostInit)) continue;
            ((IModObject.LifecyclePostInit)item).init(mo, event);
        }
    }

    private static void registerTeClasses() {
        for (IModTileEntity te : tileEntities) {
            Log.debug("Registering TileEntity " + te.getUnlocalisedName() + " as " + te.getRegistryName().toString());
            GameRegistry.registerTileEntity(te.getTileEntityClass(), (ResourceLocation)te.getRegistryName());
        }
    }

    private static RuntimeException throwCreationError(@Nonnull IModObject mo, @Nonnull String blockMethodName, @Nullable Object ex) {
        String str = "ModObject:create: Could not create instance for " + mo.getClazz() + " using method " + blockMethodName;
        Log.error(str + (ex instanceof Throwable ? " Exception: " : " Object: ") + Objects.toString(ex));
        if (ex instanceof Throwable) {
            ModObjectRegistry.disectClass(mo);
            throw new RuntimeException(str, (Throwable)ex);
        }
        throw new RuntimeException(str);
    }

    private static Object createObject(@Nonnull IModObject mo, @Nonnull String methodName) {
        Object obj;
        try {
            obj = mo.getClazz().getDeclaredMethod(methodName, IModObject.class).invoke(null, mo);
        }
        catch (Error | Exception e) {
            throw ModObjectRegistry.throwCreationError(mo, methodName, e);
        }
        return obj;
    }

    private static void disectClass(IModObject mo) {
        try {
            Method[] declaredMethods;
            Log.debug("Modobject class is " + mo.getClazz());
            for (Method method : declaredMethods = mo.getClazz().getDeclaredMethods()) {
                Annotation[] declaredAnnotations;
                Log.debug("  with method " + method);
                for (Annotation annotation : declaredAnnotations = method.getDeclaredAnnotations()) {
                    Log.debug("    with annotation " + annotation);
                }
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    private static void createBlock(@Nonnull IModObject mo, @Nonnull String blockMethodName, @Nonnull RegistryEvent.Register<Block> event) {
        Object obj = ModObjectRegistry.createObject(mo, blockMethodName);
        if (obj instanceof Block) {
            mo.setBlock((Block)obj);
            event.getRegistry().register((IForgeRegistryEntry)((Block)obj));
            reverseMapping.put(obj, mo);
        } else {
            ModObjectRegistry.throwCreationError(mo, blockMethodName, obj);
        }
    }

    private static void createItem(@Nonnull IModObject mo, @Nonnull String itemMethodName, @Nonnull RegistryEvent.Register<Item> event) {
        Object obj = ModObjectRegistry.createObject(mo, itemMethodName);
        if (obj instanceof Item) {
            mo.setItem((Item)obj);
            event.getRegistry().register((IForgeRegistryEntry)((Item)obj));
            reverseMapping.put(obj, mo);
        } else {
            ModObjectRegistry.throwCreationError(mo, itemMethodName, obj);
        }
    }

    private static void createBlockItem(IModObject mo, @Nonnull RegistryEvent.Register<Item> event) {
        Block block = mo.getBlock();
        if (block instanceof IModObject.WithBlockItem) {
            Item item = ((IModObject.WithBlockItem)block).createBlockItem(mo);
            if (item != null) {
                mo.setItem(item);
                event.getRegistry().register((IForgeRegistryEntry)item);
                reverseMapping.put(item, mo);
            }
        } else if (block == null) {
            Log.warn("ModObject:create: " + mo + " is does neither have a block nor an item");
        } else {
            Item itemFromBlock = Item.func_150898_a((Block)block);
            if (itemFromBlock != Items.field_190931_a) {
                Log.error("ModObject:create: " + mo + " is still creating its blockItem in the block phase");
                mo.setItem(itemFromBlock);
            }
        }
    }

    @Nonnull
    public static String sanitizeName(@Nonnull String name) {
        return name.replaceAll("([A-Z])", "_$0").replaceFirst("^_", "").toLowerCase(Locale.ENGLISH);
    }

    @Nullable
    public static IModObject getModObject(@Nonnull Block forBlock) {
        return reverseMapping.get(forBlock);
    }

    @Nonnull
    public static IModObject getModObjectNN(@Nonnull Block forBlock) {
        return (IModObject)NullHelper.notnull((Object)reverseMapping.get(forBlock), (String)"missing modObject");
    }

    @Nullable
    public static IModObject getModObject(@Nonnull Item forItem) {
        return reverseMapping.get(forItem);
    }

    @Nonnull
    public static IModObject getModObjectNN(@Nonnull Item forItem) {
        return (IModObject)NullHelper.notnull((Object)reverseMapping.get(forItem), (String)"missing modObject");
    }

    @Nonnull
    public static ForgeRegistry<IModObject> getRegistry() {
        return (ForgeRegistry)NullHelper.notnull(REGISTRY, (String)"accessing modobject registry too early");
    }
}

