/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.redstone;

import crazypants.enderio.base.conduit.redstone.signals.CombinedSignal;
import crazypants.enderio.base.filter.redstone.IFilterIncrementingValue;
import crazypants.enderio.base.filter.redstone.IInputSignalFilter;
import crazypants.enderio.base.lang.Lang;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TimerInputSignalFilter
implements IInputSignalFilter,
IFilterIncrementingValue {
    private int time = 20;
    private int currentTime = 0;

    @Override
    @Nonnull
    public CombinedSignal apply(@Nonnull CombinedSignal signal, @Nonnull World world, @Nonnull BlockPos pos) {
        if (signal.getStrength() == 0 && this.currentTime == this.time) {
            this.currentTime = 0;
            return CombinedSignal.MAX;
        }
        return CombinedSignal.NONE;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound t = nbtRoot.func_74775_l("currentTime");
        this.currentTime = t.func_74762_e("time");
        NBTTagCompound m = nbtRoot.func_74775_l("maxTime");
        this.time = m.func_74762_e("max");
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound c = new NBTTagCompound();
        c.func_74768_a("time", this.currentTime);
        nbtRoot.func_74782_a("currentTime", (NBTBase)c);
        NBTTagCompound m = new NBTTagCompound();
        m.func_74768_a("max", this.time);
        nbtRoot.func_74782_a("maxTime", (NBTBase)m);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public boolean shouldUpdate() {
        ++this.currentTime;
        if (this.currentTime > this.time) {
            this.currentTime = 1;
        }
        return this.currentTime == this.time || this.currentTime == 1;
    }

    @Override
    public int getIncrementingValue() {
        return this.time;
    }

    @Override
    public void setIncrementingValue(int value) {
        this.time = value;
    }

    @Override
    @Nonnull
    public String getFilterHeading() {
        return Lang.GUI_REDSTONE_FILTER_TIMER.get();
    }

    @Override
    @Nonnull
    public String getIncrementingValueName() {
        return Lang.GUI_REDSTONE_FILTER_TIME.get();
    }
}

