/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.SoulFilter;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.integration.jei.GhostSlotTarget;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.util.CapturedMob;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class SoulFilterGui
extends AbstractFilterGui {
    private static final int ID_WHITELIST = FilterGuiUtil.nextButtonId();
    private static final int ID_STICKY = FilterGuiUtil.nextButtonId();
    private final IconButton whiteListB;
    private final ToggleButton stickyB;
    @Nonnull
    private final SoulFilter filter;
    private int xOffset;
    private int yOffset;

    public SoulFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IItemFilter filter) {
        this(playerInv, filterContainer, 13, 34, te, filter);
    }

    public SoulFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, int xOffset, int yOffset, TileEntity te, @Nonnull IItemFilter filterIn) {
        super(playerInv, filterContainer, te, filterIn, "soul_filter_normal", "soul_filter_big");
        int butLeft;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.filter = (SoulFilter)filterIn;
        int x = butLeft = xOffset + 98 + 30;
        int y = yOffset + 1 - 25;
        this.whiteListB = new IconButton((IGuiScreen)this, ID_WHITELIST, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        this.stickyB = new ToggleButton((IGuiScreen)this, ID_STICKY, x += 20, y, (IWidgetIcon)IconEIO.FILTER_STICKY_OFF, (IWidgetIcon)IconEIO.FILTER_STICKY);
        this.stickyB.setSelectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_ENABLED.get(), Lang.GUI_ITEM_FILTER_STICKY_ENABLED_2.get()});
        this.stickyB.setUnselectedToolTip(new String[]{Lang.GUI_ITEM_FILTER_STICKY_DISABLED.get()});
        this.stickyB.setPaintSelectedBorder(false);
    }

    public void createFilterSlots() {
        this.filter.createGhostSlots((NNList<GhostSlot>)this.getGhostSlotHandler().getGhostSlots(), this.xOffset + 1, this.yOffset + 1 - 9, new Runnable(){

            @Override
            public void run() {
                SoulFilterGui.this.sendFilterChange();
            }
        });
    }

    @Override
    public void func_73866_w_() {
        this.createFilterSlots();
        super.func_73866_w_();
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        this.stickyB.onGuiInit();
        this.stickyB.setSelected(this.filter.isSticky());
        this.whiteListB.onGuiInit();
        if (this.filter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_BLACKLIST.get()});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        }
    }

    @Override
    public void func_146284_a(@Nonnull GuiButton guiButton) throws IOException {
        super.func_146284_a(guiButton);
        if (guiButton.field_146127_k == ID_STICKY) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_WHITELIST) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    @Override
    public void bindGuiTexture() {
        super.bindGuiTexture(this.isBig() ? 1 : 0);
    }

    @Override
    @Nonnull
    protected ResourceLocation getGuiTexture() {
        return super.getGuiTexture(this.isBig() ? 1 : 0);
    }

    @Override
    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        return (this.isBig() ? Lang.GUI_SOUL_FILTER_BIG : Lang.GUI_SOUL_FILTER_NORMAL).get();
    }

    @Override
    @Nonnull
    public List<GhostSlotTarget<?>> getGhostTargets() {
        final ArrayList targets = new ArrayList();
        this.getGhostSlotHandler().getGhostSlots().apply((NNList.Callback)new NNList.Callback<GhostSlot>(){

            public void apply(@Nonnull GhostSlot slot) {
                targets.add(new GhostSlotTarget(SoulFilterGui.this.filter, slot, SoulFilterGui.this.getGuiLeft(), SoulFilterGui.this.getGuiTop(), SoulFilterGui.this));
            }
        });
        return targets;
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int limit = (this.isBig() ? 63 : 144) - 2;
        NNList<CapturedMob> souls = this.filter.getSouls();
        for (GhostSlot slot : this.getGhostSlotHandler().getGhostSlots()) {
            int slotno;
            if (!(slot instanceof SoulFilter.SoulFilterGhostSlot) || (slotno = slot.getSlot()) >= souls.size()) continue;
            String displayName = ((CapturedMob)souls.get(slotno)).getDisplayName();
            if (fr.func_78256_a(displayName) > limit) {
                while (fr.func_78256_a(displayName + "...") > limit) {
                    displayName = displayName.substring(0, displayName.length() - 2);
                }
                displayName = displayName + "...";
            }
            fr.func_78276_b(displayName, this.getGuiLeft() + slot.getX() + 18 + 1, this.getGuiTop() + slot.getY() + 4, ColorUtil.getRGB((Color)Color.WHITE));
        }
    }

    private boolean isBig() {
        return this.filter.getSlotCount() > 5;
    }
}

