/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.render.ColorUtil;
import crazypants.enderio.base.filter.IFilter;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.filter.redstone.IFilterIncrementingValue;
import crazypants.enderio.base.lang.Lang;
import java.awt.Color;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class IncrementingValueFilterGui
extends AbstractFilterGui {
    private static final int ID_VALUE_UP = FilterGuiUtil.nextButtonId();
    private static final int ID_VALUE_DOWN = FilterGuiUtil.nextButtonId();
    @Nonnull
    private final MultiIconButton valueUpB;
    @Nonnull
    private final MultiIconButton valueDownB;
    private int xOffset;
    private int yOffset;
    @Nonnull
    private final IFilterIncrementingValue incrementingFilter;

    public IncrementingValueFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IFilter filterIn) {
        super(playerInv, filterContainer, te, filterIn);
        this.incrementingFilter = (IFilterIncrementingValue)((Object)filterIn);
        this.xOffset = 13;
        this.yOffset = 34;
        int stringWidth = this.getFontRenderer().func_78256_a(this.incrementingFilter.getIncrementingValueName());
        this.valueUpB = MultiIconButton.createAddButton((IGuiScreen)this, (int)ID_VALUE_UP, (int)(this.xOffset + stringWidth + 24), (int)(this.yOffset - 4));
        this.valueDownB = MultiIconButton.createMinusButton((IGuiScreen)this, (int)ID_VALUE_DOWN, (int)(this.xOffset + stringWidth + 24), (int)(this.yOffset + 4));
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        int multiplier = 1;
        if (IncrementingValueFilterGui.func_146272_n()) {
            multiplier *= 10;
        }
        if (IncrementingValueFilterGui.func_146271_m()) {
            multiplier *= 100;
        }
        if (IncrementingValueFilterGui.func_175283_s()) {
            multiplier *= 1000;
        }
        if (button.field_146127_k == ID_VALUE_UP) {
            this.incrementingFilter.setIncrementingValue(this.incrementingFilter.getIncrementingValue() + 1 * multiplier);
        } else if (button.field_146127_k == ID_VALUE_DOWN) {
            this.incrementingFilter.setIncrementingValue(this.incrementingFilter.getIncrementingValue() - 1 * multiplier);
        }
        this.sendFilterChange();
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        this.valueUpB.onGuiInit();
        this.valueDownB.onGuiInit();
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        FontRenderer fr = this.getFontRenderer();
        int stringWidth = this.getFontRenderer().func_78256_a(this.incrementingFilter.getIncrementingValueName());
        fr.func_78276_b(this.incrementingFilter.getIncrementingValueName(), this.getGuiLeft() + this.xOffset, this.getGuiTop() + this.yOffset, ColorUtil.getRGB((Color)Color.DARK_GRAY));
        String count = Integer.toString(this.incrementingFilter.getIncrementingValue());
        fr.func_78276_b(" " + count, this.getGuiLeft() + this.xOffset + stringWidth, this.getGuiTop() + this.yOffset, ColorUtil.getRGB((Color)Color.DARK_GRAY));
        super.renderCustomOptions(top, par1, par2, par3);
    }

    @Override
    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        return Lang.GUI_REDSTONE_FILTER_TIMER.get();
    }
}

