/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.filter.gui;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.base.filter.fluid.FluidFilter;
import crazypants.enderio.base.filter.fluid.IFluidFilter;
import crazypants.enderio.base.filter.gui.AbstractFilterGui;
import crazypants.enderio.base.filter.gui.ContainerFilter;
import crazypants.enderio.base.filter.gui.FilterGuiUtil;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.integration.jei.GhostSlotTarget;
import crazypants.enderio.base.lang.Lang;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterGui
extends AbstractFilterGui {
    private static final int ID_WHITELIST = FilterGuiUtil.nextButtonId();
    private final IconButton whiteListB;
    @Nonnull
    private final FluidFilter filter;
    private int xOffset = 13;
    private int yOffset = 34;

    public FluidFilterGui(@Nonnull InventoryPlayer playerInv, @Nonnull ContainerFilter filterContainer, TileEntity te, @Nonnull IFluidFilter filterIn) {
        super(playerInv, filterContainer, te, filterIn, "fluid_filter");
        int butLeft;
        this.filter = (FluidFilter)filterIn;
        int x = butLeft = this.xOffset + 98;
        int y = this.yOffset + 1;
        this.whiteListB = new IconButton((IGuiScreen)this, ID_WHITELIST, x, y, (IWidgetIcon)IconEIO.FILTER_WHITELIST);
        this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
    }

    @Override
    public void func_73866_w_() {
        this.createFilterSlots();
        super.func_73866_w_();
    }

    public void createFilterSlots() {
        this.filter.createGhostSlots((NNList<GhostSlot>)this.getGhostSlotHandler().getGhostSlots(), this.xOffset + 1, this.yOffset + 1, new Runnable(){

            @Override
            public void run() {
                FluidFilterGui.this.sendFilterChange();
            }
        });
    }

    @Override
    public void updateButtons() {
        super.updateButtons();
        this.whiteListB.onGuiInit();
        if (this.filter.isBlacklist()) {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_BLACKLIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_BLACKLIST.get()});
        } else {
            this.whiteListB.setIcon((IWidgetIcon)IconEIO.FILTER_WHITELIST);
            this.whiteListB.setToolTip(new String[]{Lang.GUI_ITEM_FILTER_WHITELIST.get()});
        }
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == ID_WHITELIST) {
            this.filter.setBlacklist(!this.filter.isBlacklist());
            this.sendFilterChange();
        }
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
        int x = this.getGuiLeft() + this.xOffset;
        int y = this.getGuiTop() + this.yOffset;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        if (!this.filter.isEmpty()) {
            for (int i = 0; i < this.filter.size(); ++i) {
                FluidStack f = this.filter.getFluidStackAt(i);
                if (f == null) continue;
                this.renderFluid(f, x + i * 18, y);
            }
        }
    }

    private void renderFluid(FluidStack f, int x, int y) {
        ResourceLocation iconKey = f.getFluid().getStill();
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().getTextureExtry(iconKey.toString());
        if (icon != null) {
            RenderUtil.renderGuiTank((FluidStack)f, (int)1000, (int)1000, (double)(x + 1), (double)(y + 1), (double)0.0, (double)16.0, (double)16.0);
        }
    }

    @Override
    @Nonnull
    protected String getUnlocalisedNameForHeading() {
        return Lang.GUI_FLUID_FILTER.get();
    }

    @Override
    @Nonnull
    public List<GhostSlotTarget<?>> getGhostTargets() {
        ArrayList targets = new ArrayList();
        for (GhostSlot slot : this.getGhostSlotHandler().getGhostSlots()) {
            targets.add(new GhostSlotTarget(this.filter, slot, this.getGuiLeft(), this.getGuiTop(), this));
        }
        return targets;
    }
}

