/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import com.enderio.core.common.util.stackable.Things;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.FluidAmount;
import crazypants.enderio.base.config.recipes.xml.Item;
import crazypants.enderio.base.config.recipes.xml.ItemIntegerAmount;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.RecipeLevel;
import crazypants.enderio.base.recipe.tank.TankMachineRecipe;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import net.minecraftforge.fluids.FluidStack;

public class Tanking
extends AbstractConditional {
    private Item input;
    private ItemIntegerAmount output;
    private FluidAmount fluid;
    @Nonnull
    private TankMachineRecipe.Logic logic = TankMachineRecipe.Logic.NONE;
    private Type type;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.input == null) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            if (this.fluid == null) {
                throw new InvalidRecipeConfigException("Missing <fluid>");
            }
            if (this.type == null) {
                throw new InvalidRecipeConfigException("Missing attribute 'type'");
            }
            this.valid = this.input.isValid() && this.fluid.isValid() && (this.output == null || this.output.isValid());
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <tanking>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.input.enforceValidity();
        if (this.input.getThing().isEmpty()) {
            throw new InvalidRecipeConfigException("Valid child elements are invalid in <tanking>");
        }
        this.fluid.enforceValidity();
        if (this.output != null) {
            this.output.enforceValidity();
            if (this.output.getThing().isEmpty()) {
                throw new InvalidRecipeConfigException("Valid child elements are invalid in <tanking>");
            }
        }
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            boolean isFilling;
            Things inThing = this.input.getThing();
            Things outThing = this.output != null ? this.output.getThing() : null;
            FluidStack fluidStack = this.fluid.getFluidStack();
            boolean bl = isFilling = this.type == Type.FILL;
            if (!inThing.isEmpty()) {
                TankMachineRecipe recipe = new TankMachineRecipe(recipeName, isFilling, inThing, fluidStack, outThing, this.logic, RecipeLevel.IGNORE);
                MachineRecipeRegistry.instance.registerRecipe(recipe);
            }
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("logic".equals(name)) {
            try {
                this.logic = TankMachineRecipe.Logic.valueOf(value.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecipeConfigException("'" + value + "' is not a valid value for 'logic'");
            }
            return true;
        }
        if ("type".equals(name)) {
            try {
                this.type = Type.valueOf(value.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new InvalidRecipeConfigException("'" + value + "' is not a valid value for 'type'");
            }
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && this.input == null) {
            this.input = (Item)factory.read(new Item().setAllowDelaying(false), startElement);
            return true;
        }
        if ("fluid".equals(name) && this.fluid == null) {
            this.fluid = factory.read(new FluidAmount(), startElement);
            return true;
        }
        if ("output".equals(name) && this.output == null) {
            this.output = (ItemIntegerAmount)factory.read(new ItemIntegerAmount().setAllowDelaying(false), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }

    private static enum Type {
        EMPTY,
        FILL;

    }
}

