/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.registry;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IServerConduit;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.conduit.geom.Offsets;
import crazypants.enderio.base.conduit.registry.ConduitDefinition;
import crazypants.enderio.base.conduit.registry.ConduitTypeDefinition;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;

public class ConduitRegistry {
    private static final Map<UUID, ConduitTypeDefinition> UUID_TO_NETWORK = new HashMap<UUID, ConduitTypeDefinition>();
    private static final Map<UUID, ConduitDefinition> UUID_TO_CONDUIT = new HashMap<UUID, ConduitDefinition>();
    private static final Map<Class<? extends IConduit>, UUID> CLASS_TO_UUID = new IdentityHashMap<Class<? extends IConduit>, UUID>();
    private static boolean sortingSupported = true;
    private static final Comparator<IConduit> CONDUIT_COMPERATOR = new Comparator<IConduit>(){

        @Override
        public int compare(IConduit o1, IConduit o2) {
            return ConduitRegistry.getNetwork(o1).getUUID().compareTo(ConduitRegistry.getNetwork(o2).getUUID());
        }
    };
    private static IModObject conduitBlock = null;

    public static void register(ConduitTypeDefinition info) {
        UUID_TO_NETWORK.put(info.getUUID(), info);
        for (UUID uuid : info.getAliases()) {
            UUID_TO_NETWORK.put(uuid, info);
        }
        CLASS_TO_UUID.put(info.getBaseType(), info.getUUID());
        for (ConduitDefinition member : info.getMembers()) {
            UUID_TO_CONDUIT.put(member.getUUID(), member);
            for (UUID uuid : member.getAliases()) {
                UUID_TO_CONDUIT.put(uuid, member);
            }
            CLASS_TO_UUID.put(member.getServerClass(), member.getUUID());
            CLASS_TO_UUID.put(member.getClientClass(), member.getUUID());
            ConduitRegistry.getServerInstance(member.getUUID());
            if (EnderIO.proxy.isDedicatedServer()) continue;
            ConduitRegistry.getClientInstance(member.getUUID());
        }
        Offset none = info.getPreferedOffsetForNone();
        Offset x = info.getPreferedOffsetForX();
        Offset y = info.getPreferedOffsetForY();
        Offset z = info.getPreferedOffsetForZ();
        while (!Offsets.registerOffsets(info.getBaseType(), none, x, y, z)) {
            if ((z = z.next()) == null) {
                z = Offset.first();
            }
            if (z == info.getPreferedOffsetForZ()) {
                if ((y = y.next()) == null) {
                    y = Offset.first();
                }
                if (y == info.getPreferedOffsetForY()) {
                    if ((x = x.next()) == null) {
                        x = Offset.first();
                    }
                    if (x == info.getPreferedOffsetForX() && (none = none.next()) == null) {
                        none = Offset.first();
                    }
                }
            }
            if (z != info.getPreferedOffsetForZ() || y != info.getPreferedOffsetForY() || x != info.getPreferedOffsetForX() || none != info.getPreferedOffsetForNone()) continue;
            throw new RuntimeException("Failed to find free offsets for " + info.getBaseType());
        }
    }

    public static ConduitDefinition get(IConduit conduit) {
        return UUID_TO_CONDUIT.get(CLASS_TO_UUID.get(conduit.getClass()));
    }

    public static ConduitDefinition get(UUID uuid) {
        return UUID_TO_CONDUIT.get(uuid);
    }

    public static ConduitTypeDefinition getNetwork(IConduit conduit) {
        return ConduitRegistry.getNetwork(CLASS_TO_UUID.get(conduit.getClass()));
    }

    public static ConduitTypeDefinition getNetwork(UUID uuid) {
        ConduitTypeDefinition network = UUID_TO_NETWORK.get(uuid);
        return network != null ? network : ConduitRegistry.get(uuid).getNetwork();
    }

    public static Collection<ConduitDefinition> getAll() {
        return UUID_TO_CONDUIT.values();
    }

    public static IServerConduit getServerInstance(UUID uuid) {
        try {
            return UUID_TO_CONDUIT.get(uuid).getServerClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create an instance of the conduit of type " + uuid, e);
        }
    }

    public static IClientConduit getClientInstance(UUID uuid) {
        try {
            return UUID_TO_CONDUIT.get(uuid).getClientClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create an instance of the conduit of type " + uuid, e);
        }
    }

    public static void sort(List<IConduit> conduits) {
        if (sortingSupported) {
            try {
                Collections.sort(conduits, CONDUIT_COMPERATOR);
            }
            catch (UnsupportedOperationException e) {
                sortingSupported = false;
            }
        }
    }

    @Nullable
    public static Block getConduitBlock() {
        return conduitBlock == null ? null : conduitBlock.getBlock();
    }

    @Nullable
    public static IModObject getConduitModObject() {
        return conduitBlock;
    }

    @Nonnull
    public static IModObject getConduitModObjectNN() {
        return (IModObject)NullHelper.notnull((Object)conduitBlock, (String)"Cannot use conduits unless conduits submod is installed");
    }

    public static void registerConduitBlock(@Nonnull IModObject block) {
        conduitBlock = block;
    }
}

