/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.capacitor.Scaler;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.capacitor.CapacitorKeyRegistry;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Triple;

public class PacketCapacitorSync
implements IMessage {
    @Nonnull
    final NNList<Triple<ResourceLocation, Integer, String>> data = new NNList();

    public PacketCapacitorSync() {
    }

    public PacketCapacitorSync(@Nonnull Map<ICapacitorKey, Triple<Integer, Scaler, String>> map) {
        for (Map.Entry<ICapacitorKey, Triple<Integer, Scaler, String>> entry : map.entrySet()) {
            ICapacitorKey key = entry.getKey();
            Triple<Integer, Scaler, String> value = entry.getValue();
            if (key == null || value == null) continue;
            ResourceLocation registryName = key.getRegistryName();
            Integer baseValue = (Integer)value.getLeft();
            String scaler = (String)value.getRight();
            if (baseValue == null || scaler == null) continue;
            this.data.add((Object)Triple.of((Object)registryName, (Object)baseValue, (Object)scaler));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.data.size());
        for (Triple triple : this.data) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((ResourceLocation)triple.getLeft()).toString());
            buf.writeInt(((Integer)triple.getMiddle()).intValue());
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)triple.getRight()));
        }
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            String name = ByteBufUtils.readUTF8String((ByteBuf)buf);
            int baseValue = buf.readInt();
            String scaler = ByteBufUtils.readUTF8String((ByteBuf)buf);
            ResourceLocation registryName = new ResourceLocation((String)NullHelper.first((Object[])new String[]{name, ""}));
            this.data.add((Object)Triple.of((Object)registryName, (Object)baseValue, (Object)scaler));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketCapacitorSync, IMessage> {
        public IMessage onMessage(PacketCapacitorSync message, MessageContext ctx) {
            if (!Minecraft.func_71410_x().func_71387_A()) {
                for (Triple triple : message.data) {
                    CapacitorKeyRegistry.addOverride((ResourceLocation)NullHelper.notnull((Object)triple.getLeft(), (String)"internal error"), (Integer)triple.getMiddle(), (String)triple.getRight());
                }
                Log.debug("Added server config overrides for capacitor keys");
            } else {
                Log.debug("Ignoring server config overrides for capacitor keys in sinple player");
            }
            return null;
        }
    }
}

