/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.base.EnderIO;
import javax.annotation.Nonnull;

public enum DefaultCapacitorData implements ICapacitorData
{
    BASIC_CAPACITOR("basic", 1),
    ACTIVATED_CAPACITOR("activated", 2),
    ENDER_CAPACITOR("ender", 3),
    SPECIAL_CAPACITOR("special"),
    SPECIAL2_CAPACITOR("special2");

    @Nonnull
    public static final ICapacitorData NONE;
    @Nonnull
    private final String unlocalizedName;
    private final int baselevel;
    private final boolean regular;

    private DefaultCapacitorData(String unlocalizedName) {
        this(unlocalizedName, 1, false);
    }

    private DefaultCapacitorData(String unlocalizedName, int baselevel) {
        this(unlocalizedName, baselevel, true);
    }

    private DefaultCapacitorData(String unlocalizedName, int baselevel, boolean regular) {
        this.unlocalizedName = unlocalizedName;
        this.baselevel = baselevel;
        this.regular = regular;
    }

    @Override
    @Nonnull
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    @Nonnull
    public String getLocalizedName() {
        return EnderIO.lang.localize(this.getUnlocalizedName() + ".name");
    }

    @Override
    public float getUnscaledValue(@Nonnull ICapacitorKey key) {
        return this.baselevel;
    }

    public boolean isRegular() {
        return this.regular;
    }

    static {
        NONE = new ICapacitorData(){

            @Override
            public float getUnscaledValue(@Nonnull ICapacitorKey key) {
                return 0.0f;
            }

            @Override
            @Nonnull
            public String getUnlocalizedName() {
                return "none";
            }

            @Override
            @Nonnull
            public String getLocalizedName() {
                return "none";
            }

            public int hashCode() {
                return 42;
            }

            public boolean equals(Object obj) {
                return this == obj;
            }
        };
    }
}

