/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.block.painted;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.BlockEnder;
import com.enderio.core.common.transform.EnderCoreMethods;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.block.painted.BlockItemPaintedBlock;
import crazypants.enderio.base.block.painted.EnumPressurePlateType;
import crazypants.enderio.base.block.painted.TilePaintedPressurePlate;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.material.glass.BlockFusedQuartzBase;
import crazypants.enderio.base.paint.IPaintable;
import crazypants.enderio.base.paint.PaintUtil;
import crazypants.enderio.base.paint.render.PaintHelper;
import crazypants.enderio.base.paint.render.PaintRegistry;
import crazypants.enderio.base.recipe.MachineRecipeRegistry;
import crazypants.enderio.base.recipe.painter.PressurePlatePainterTemplate;
import crazypants.enderio.base.render.IBlockStateWrapper;
import crazypants.enderio.base.render.ICacheKey;
import crazypants.enderio.base.render.ICustomSubItems;
import crazypants.enderio.base.render.IRenderMapper;
import crazypants.enderio.base.render.ISmartRenderAwareBlock;
import crazypants.enderio.base.render.itemoverlay.MobNameOverlayRenderHelper;
import crazypants.enderio.base.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.base.render.property.EnumRenderPart;
import crazypants.enderio.base.render.registry.SmartModelAttacher;
import crazypants.enderio.base.render.util.QuadCollector;
import crazypants.enderio.util.CapturedMob;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.BlockPressurePlateWeighted;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPaintedPressurePlate
extends BlockBasePressurePlate
implements ITileEntityProvider,
IPaintable.ITexturePaintableBlock,
ISmartRenderAwareBlock,
IRenderMapper.IBlockRenderMapper.IRenderLayerAware,
BlockItemPaintedBlock.INamedSubBlocks,
IResourceTooltipProvider,
IRenderMapper.IItemRenderMapper.IItemModelMapper,
IModObject.WithBlockItem,
ICustomSubItems {
    private final NNList<IBlockState> defaultPaints = new NNList(EnumPressurePlateType.values().length, (Object)Blocks.field_150452_aw.func_176223_P());

    public static BlockPaintedPressurePlate create(@Nonnull IModObject modObject) {
        BlockPaintedPressurePlate result = new BlockPaintedPressurePlate(modObject);
        result.func_149711_c(0.5f);
        result.init(modObject);
        MachineRecipeRegistry.instance.registerRecipe("painter", new PressurePlatePainterTemplate(result, EnumPressurePlateType.WOOD.getMetaFromType(), Blocks.field_150452_aw));
        MachineRecipeRegistry.instance.registerRecipe("painter", new PressurePlatePainterTemplate(result, EnumPressurePlateType.STONE.getMetaFromType(), Blocks.field_150456_au));
        MachineRecipeRegistry.instance.registerRecipe("painter", new PressurePlatePainterTemplate(result, EnumPressurePlateType.IRON.getMetaFromType(), Blocks.field_150443_bT));
        MachineRecipeRegistry.instance.registerRecipe("painter", new PressurePlatePainterTemplate(result, EnumPressurePlateType.GOLD.getMetaFromType(), Blocks.field_150445_bS));
        return result;
    }

    public BlockPaintedPressurePlate(@Nonnull IModObject modObject) {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(EnderIOTab.tabEnderIO);
        modObject.apply(this);
        this.func_149672_a(SoundType.field_185848_a);
    }

    private void init(@Nonnull IModObject modObject) {
        SmartModelAttacher.registerNoProps((Block)this);
        PaintRegistry.registerModel("pressure_plate_up", new ResourceLocation("minecraft", "block/stone_pressure_plate_up"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("pressure_plate_down", new ResourceLocation("minecraft", "block/stone_pressure_plate_down"), PaintRegistry.PaintMode.ALL_TEXTURES);
        PaintRegistry.registerModel("pressure_plate_inventory", new ResourceLocation("minecraft", "block/stone_pressure_plate_up"), PaintRegistry.PaintMode.ALL_TEXTURES);
        this.defaultPaints.set(EnumPressurePlateType.WOOD.ordinal(), (Object)Blocks.field_150452_aw.func_176223_P());
        this.defaultPaints.set(EnumPressurePlateType.STONE.ordinal(), (Object)Blocks.field_150456_au.func_176223_P());
        this.defaultPaints.set(EnumPressurePlateType.IRON.ordinal(), (Object)Blocks.field_150443_bT.func_176223_P());
        this.defaultPaints.set(EnumPressurePlateType.GOLD.ordinal(), (Object)Blocks.field_150445_bS.func_176223_P());
        this.defaultPaints.set(EnumPressurePlateType.DARKSTEEL.ordinal(), (Object)this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(1)));
        this.defaultPaints.set(EnumPressurePlateType.SOULARIUM.ordinal(), (Object)this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(2)));
        this.defaultPaints.set(EnumPressurePlateType.TUNED.ordinal(), (Object)this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(3)));
    }

    @Override
    public Item createBlockItem(@Nonnull IModObject modObject) {
        return modObject.apply(new BlockItemPaintedPressurePlate(this));
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return new TilePaintedPressurePlate();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockPressurePlateWeighted.field_176579_a});
    }

    protected int func_180669_e(@Nonnull World worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            EnumPressurePlateType type = ((TilePaintedPressurePlate)te).getType();
            return type.getCountingMode().count(worldIn.func_175647_a(type.getSearchClass(), field_185511_c.func_186670_a(pos), type.getPredicate(this.getMobType((IBlockAccess)worldIn, pos))));
        }
        return this.func_176576_e(worldIn.func_180495_p(pos));
    }

    protected int func_176576_e(@Nonnull IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a);
    }

    @Nonnull
    protected IBlockState func_176575_a(@Nonnull IBlockState state, int strength) {
        return state.func_177226_a((IProperty)BlockPressurePlateWeighted.field_176579_a, (Comparable)Integer.valueOf(strength));
    }

    protected void setTypeFromMeta(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos, int meta) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TilePaintedPressurePlate) {
            ((TilePaintedPressurePlate)te).setType(EnumPressurePlateType.getTypeFromMeta(meta));
            ((TilePaintedPressurePlate)te).setSilent(EnumPressurePlateType.getSilentFromMeta(meta));
        }
    }

    protected int getMetaForStack(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return EnumPressurePlateType.getMetaFromType(((TilePaintedPressurePlate)te).getType(), ((TilePaintedPressurePlate)te).isSilent());
        }
        return 0;
    }

    protected EnumPressurePlateType getType(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).getType();
        }
        return EnumPressurePlateType.WOOD;
    }

    protected boolean isSilent(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).isSilent();
        }
        return false;
    }

    protected CapturedMob getMobType(@Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)worldIn, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).getMobType();
        }
        return null;
    }

    protected void setMobType(IBlockAccess worldIn, @Nonnull BlockPos pos, CapturedMob mobType) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TilePaintedPressurePlate) {
            ((TilePaintedPressurePlate)te).setMobType(mobType);
        }
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer) {
        return this.func_176223_P();
    }

    public void func_180633_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack stack) {
        this.setTypeFromMeta((IBlockAccess)worldIn, pos, stack.func_77960_j());
        this.setPaintSource(state, (IBlockAccess)worldIn, pos, PaintUtil.getSourceBlock(stack));
        this.setRotation((IBlockAccess)worldIn, pos, EnumFacing.func_176733_a((double)placer.field_70177_z));
        this.setMobType((IBlockAccess)worldIn, pos, CapturedMob.create(stack));
        if (!worldIn.field_72995_K) {
            worldIn.func_184138_a(pos, state, state, 3);
        }
    }

    public boolean rotateBlock(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing axis) {
        this.setRotation((IBlockAccess)world, pos, this.getRotation((IBlockAccess)world, pos).func_176732_a(EnumFacing.Axis.Y));
        return true;
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity te, @Nonnull ItemStack item) {
        super.func_180657_a(worldIn, player, pos, state, te, item);
        super.removedByPlayer(state, worldIn, pos, player, true);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        drops.add((Object)this.getDrop(world, pos));
    }

    @Nonnull
    protected ItemStack getDrop(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        CapturedMob mobType = this.getMobType(world, pos);
        ItemStack drop = mobType != null ? mobType.toStack(Item.func_150898_a((Block)this), this.getMetaForStack(world, pos), 1) : new ItemStack(Item.func_150898_a((Block)this), 1, this.getMetaForStack(world, pos));
        PaintUtil.setSourceBlock(drop, this.getPaintSource(world.func_180495_p(pos), world, pos));
        return drop;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, @Nonnull RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
        return this.getDrop((IBlockAccess)world, pos);
    }

    @Override
    public void setPaintSource(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable IBlockState paintSource) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IPaintable.IPaintableTileEntity) {
            if (this.defaultPaints.get(this.getType(world, pos).ordinal()) == paintSource) {
                ((IPaintable.IPaintableTileEntity)te).setPaintSource(null);
            } else {
                ((IPaintable.IPaintableTileEntity)te).setPaintSource(paintSource);
            }
        }
    }

    @Override
    public void setPaintSource(@Nonnull Block block, @Nonnull ItemStack stack, @Nullable IBlockState paintSource) {
        if (this.defaultPaints.get(EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()).ordinal()) == paintSource) {
            PaintUtil.setSourceBlock(stack, null);
        } else {
            PaintUtil.setSourceBlock(stack, paintSource);
        }
    }

    @Override
    public IBlockState getPaintSource(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        IBlockState paintSource;
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof IPaintable.IPaintableTileEntity && (paintSource = ((IPaintable.IPaintableTileEntity)te).getPaintSource()) != null) {
            return paintSource;
        }
        return (IBlockState)this.defaultPaints.get(this.getType(world, pos).ordinal());
    }

    @Override
    public IBlockState getPaintSource(@Nonnull Block block, @Nonnull ItemStack stack) {
        IBlockState paintSource = PaintUtil.getSourceBlock(stack);
        return paintSource != null ? paintSource : (IBlockState)this.defaultPaints.get(EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()).ordinal());
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, this);
        blockStateWrapper.addCacheKey(this.getPaintSource(state, world, pos)).addCacheKey(this.getRotation(world, pos)).addCacheKey((Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a) > 0);
        blockStateWrapper.bakeModel();
        return blockStateWrapper;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private IBakedModel mapRender(IBlockState state, @Nullable IBlockState paint, EnumFacing facing) {
        ModelRotation rot;
        switch (facing) {
            case EAST: {
                rot = ModelRotation.X0_Y90;
                break;
            }
            case NORTH: {
                rot = null;
                break;
            }
            case SOUTH: {
                rot = ModelRotation.X0_Y180;
                break;
            }
            case WEST: {
                rot = ModelRotation.X0_Y270;
                break;
            }
            default: {
                return null;
            }
        }
        if ((Integer)state.func_177229_b((IProperty)BlockPressurePlateWeighted.field_176579_a) > 0) {
            return PaintRegistry.getModel(IBakedModel.class, "pressure_plate_down", paint, (IModelState)rot);
        }
        return PaintRegistry.getModel(IBakedModel.class, "pressure_plate_up", paint, (IModelState)rot);
    }

    protected EnumFacing getRotation(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return ((TilePaintedPressurePlate)te).getRotation();
        }
        return EnumFacing.NORTH;
    }

    protected void setRotation(IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing rotation) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePaintedPressurePlate) {
            ((TilePaintedPressurePlate)te).setRotation(rotation);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey.addCacheKey(this.getPaintSource(block, stack));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBakedModel> mapItemRender(@Nonnull Block block, @Nonnull ItemStack stack) {
        IBlockState paintSource = this.getPaintSource(block, stack);
        IBakedModel model1 = PaintRegistry.getModel(IBakedModel.class, "pressure_plate_inventory", paintSource, null);
        ArrayList<IBakedModel> list = new ArrayList<IBakedModel>();
        list.add(model1);
        if (paintSource != this.defaultPaints.get(EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()).ordinal())) {
            IBlockState stdOverlay = ModObject.block_machine_base.getBlockNN().func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)EnumRenderPart.PAINT_OVERLAY));
            IBakedModel model2 = PaintRegistry.getModel(IBakedModel.class, "pressure_plate_inventory", stdOverlay, PaintRegistry.OVERLAY_TRANSFORMATION);
            list.add(model2);
        }
        return list;
    }

    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public int getFlammability(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return EnumPressurePlateType.WOOD == ((TilePaintedPressurePlate)te).getType() ? 20 : 0;
        }
        return 0;
    }

    public int getFireSpreadSpeed(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        TileEntity te = BlockEnder.getAnyTileEntitySafe((IBlockAccess)world, (BlockPos)pos);
        if (te instanceof TilePaintedPressurePlate) {
            return EnumPressurePlateType.WOOD == ((TilePaintedPressurePlate)te).getType() ? 5 : 0;
        }
        return 0;
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        for (EnumPressurePlateType type : EnumPressurePlateType.values()) {
            if (!type.isShadowsVanilla()) {
                list.add((Object)new ItemStack((Block)this, 1, EnumPressurePlateType.getMetaFromType(type, false)));
            }
            list.add((Object)new ItemStack((Block)this, 1, EnumPressurePlateType.getMetaFromType(type, true)));
        }
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getSubItems() {
        NNList list = new NNList();
        for (EnumPressurePlateType type : EnumPressurePlateType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, EnumPressurePlateType.getMetaFromType(type, false)));
            list.add((Object)new ItemStack((Block)this, 1, EnumPressurePlateType.getMetaFromType(type, true)));
        }
        return list;
    }

    protected void func_180666_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, int oldRedstoneStrength) {
        boolean isOn;
        int newRedstoneStrength = this.func_180669_e(worldIn, pos);
        boolean wasOn = oldRedstoneStrength > 0;
        boolean bl = isOn = newRedstoneStrength > 0;
        if (oldRedstoneStrength != newRedstoneStrength) {
            state = this.func_176575_a(state, newRedstoneStrength);
            worldIn.func_180501_a(pos, state, 2);
            this.func_176578_d(worldIn, pos);
            worldIn.func_175704_b(pos, pos);
            if (!this.isSilent((IBlockAccess)worldIn, pos)) {
                if (!isOn && wasOn) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.5f);
                } else if (isOn && !wasOn) {
                    worldIn.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 0.6f);
                }
            }
        }
        if (isOn) {
            worldIn.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, this.func_149738_a(worldIn));
        }
    }

    @Override
    @Nonnull
    public String getUnlocalizedName(int meta) {
        return this.func_149739_a() + "." + EnumPressurePlateType.getTypeFromMeta(meta).func_176610_l() + (EnumPressurePlateType.getSilentFromMeta(meta) ? ".silent" : "");
    }

    @Nonnull
    public String getUnlocalizedNameForTooltip(@Nonnull ItemStack itemStack) {
        return this.getUnlocalizedName(itemStack.func_77960_j());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(@Nonnull IBlockStateWrapper state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable BlockRenderLayer blockLayer, @Nonnull QuadCollector quadCollector) {
        IBlockState paintSource = this.getPaintSource(state, world, pos);
        if (!(blockLayer != null && !PaintUtil.canRenderInLayer(paintSource, blockLayer) || paintSource != null && paintSource.func_177230_c() instanceof BlockFusedQuartzBase)) {
            quadCollector.addFriendlybakedModel(blockLayer, this.mapRender(state, paintSource, this.getRotation(world, pos)), paintSource, MathHelper.func_180186_a((Vec3i)pos));
        }
        return null;
    }

    protected void func_185507_b(@Nonnull World worldIn, @Nonnull BlockPos color) {
        if (this.field_149764_J == Material.field_151575_d) {
            worldIn.func_184133_a((EntityPlayer)null, color, SoundEvents.field_187895_gX, SoundCategory.BLOCKS, 0.3f, 0.8f);
        } else {
            worldIn.func_184133_a((EntityPlayer)null, color, SoundEvents.field_187901_ga, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    protected void func_185508_c(@Nonnull World worldIn, @Nonnull BlockPos pos) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(@Nonnull IBlockState state, @Nonnull World world, @Nonnull RayTraceResult target, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addHitEffects(state, world, target, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull ParticleManager effectRenderer) {
        return PaintHelper.addDestroyEffects(world, pos, effectRenderer);
    }

    public static class BlockItemPaintedPressurePlate
    extends BlockItemPaintedBlock
    implements EnderCoreMethods.IOverlayRenderAware {
        public BlockItemPaintedPressurePlate(@Nonnull BlockPaintedPressurePlate block) {
            super((Block)block);
        }

        public boolean func_77636_d(@Nonnull ItemStack stack) {
            return EnumPressurePlateType.getTypeFromMeta(stack.func_77960_j()) == EnumPressurePlateType.TUNED;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, tooltip, flagIn);
            CapturedMob capturedMob = CapturedMob.create(stack);
            if (capturedMob != null) {
                tooltip.add(Lang.PRESSURE_PLATE_TUNED.get(capturedMob.getDisplayName()));
            }
        }

        public void renderItemOverlayIntoGUI(@Nonnull ItemStack stack, int xPosition, int yPosition) {
            MobNameOverlayRenderHelper.doItemOverlayIntoGUI(stack, xPosition, yPosition);
        }
    }
}

