/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api.upgrades;

import com.google.common.collect.Multimap;
import crazypants.enderio.api.capacitor.ICapacitorKey;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.api.upgrades.IEquipmentData;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;

public interface IDarkSteelItem {
    default public int getIngotsRequiredForFullRepair() {
        return 9;
    }

    default public boolean isItemForRepair(@Nonnull ItemStack right) {
        return false;
    }

    default public boolean isForSlot(@Nonnull EntityEquipmentSlot slot) {
        return false;
    }

    default public boolean isWeapon() {
        return this instanceof ItemSword || this.isAxe();
    }

    default public boolean isBlockBreakingTool() {
        return this.isPickaxe() || this.isAxe();
    }

    default public boolean isPickaxe() {
        return false;
    }

    default public boolean isAxe() {
        return false;
    }

    default public boolean hasUpgradeCallbacks(@Nonnull IDarkSteelUpgrade upgrade) {
        return false;
    }

    @Nonnull
    public IEquipmentData getEquipmentData();

    @Nonnull
    public ICapacitorKey getEnergyStorageKey(@Nonnull ItemStack var1);

    @Nonnull
    public ICapacitorKey getEnergyInputKey(@Nonnull ItemStack var1);

    @Nonnull
    public ICapacitorKey getEnergyUseKey(@Nonnull ItemStack var1);

    default public boolean allowExtractEnergy() {
        return false;
    }

    @Nonnull
    public ICapacitorKey getAbsorptionRatioKey(@Nonnull ItemStack var1);

    default public int getMaxEmpoweredLevel(@Nonnull ItemStack stack) {
        return this.getEquipmentData().getTier() >= 2 ? 4 : 3;
    }

    @Nonnull
    default public Multimap<String, AttributeModifier> addAttributeModifiers(@Nonnull EntityEquipmentSlot slot, @Nonnull ItemStack stack, @Nonnull Multimap<String, AttributeModifier> map) {
        for (IDarkSteelUpgrade upgrade : UpgradeRegistry.getUpgrades()) {
            if (!upgrade.hasUpgrade(stack)) continue;
            upgrade.addAttributeModifiers(slot, stack, map);
        }
        return map;
    }
}

