/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ExchangingModes {
    private static boolean isReplaceable(World world, BlockPos pos, IBlockState currentBlock, IBlockState setBlock, boolean fuzzyMode) {
        IBlockState worldBlockState = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (worldBlockState != currentBlock && !fuzzyMode) {
            return false;
        }
        if (worldBlockState == ModBlocks.effectBlock.func_176223_P()) {
            return false;
        }
        if (worldBlockState == setBlock) {
            return false;
        }
        if (te != null && !(te instanceof ConstructionBlockTileEntity)) {
            return false;
        }
        if (te instanceof ConstructionBlockTileEntity && ((ConstructionBlockTileEntity)te).getBlockState() == setBlock) {
            return false;
        }
        if (worldBlockState.func_185887_b(world, pos) < 0.0f) {
            return false;
        }
        if (worldBlockState.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        return !worldBlockState.func_185904_a().func_76224_d();
    }

    public static void addConnectedCoords(World world, BlockPos loc, IBlockState state, IBlockState setBlock, boolean fuzzyMode, List<BlockPos> coords, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (coords.contains(loc) || loc.func_177958_n() < minX || loc.func_177956_o() < minY || loc.func_177952_p() < minZ || loc.func_177958_n() > maxX || loc.func_177956_o() > maxY || loc.func_177952_p() > maxZ) {
            return;
        }
        if (!ExchangingModes.isReplaceable(world, loc, state, setBlock, fuzzyMode)) {
            return;
        }
        coords.add(loc);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    ExchangingModes.addConnectedCoords(world, loc.func_177982_a(x, y, z), state, setBlock, fuzzyMode, coords, minX, minY, minZ, maxX, maxY, maxZ);
                }
            }
        }
    }

    public static List<BlockPos> getBuildOrders(World world, EntityPlayer player, BlockPos startBlock, EnumFacing sideHit, ItemStack tool) {
        ArrayList<BlockPos> coordinates;
        block29: {
            int z;
            IBlockState currentBlock;
            BlockPos pos;
            boolean fuzzyMode;
            int range;
            IBlockState setBlock;
            GadgetExchanger.ToolMode mode;
            block27: {
                int bound;
                block30: {
                    block28: {
                        int boundZS;
                        int boundXS;
                        int boundZ;
                        int boundX;
                        mode = GadgetExchanger.getToolMode(tool);
                        setBlock = GadgetUtils.getToolBlock(tool);
                        range = GadgetUtils.getToolRange(tool);
                        fuzzyMode = GadgetGeneric.getFuzzy(tool);
                        coordinates = new ArrayList<BlockPos>();
                        pos = startBlock;
                        bound = (range - 1) / 2;
                        EnumFacing playerFacing = player.func_174811_aO();
                        if (playerFacing == EnumFacing.SOUTH || playerFacing == EnumFacing.NORTH) {
                            boundX = bound;
                            boundZ = 0;
                        } else {
                            boundX = 0;
                            boundZ = bound;
                        }
                        if (sideHit == EnumFacing.SOUTH || sideHit == EnumFacing.NORTH) {
                            boundXS = bound;
                            boundZS = 0;
                        } else {
                            boundXS = 0;
                            boundZS = bound;
                        }
                        currentBlock = world.func_180495_p(startBlock);
                        if (mode == GadgetExchanger.ToolMode.Surface) {
                            if (GadgetGeneric.getConnectedArea(tool)) {
                                AxisAlignedBB area = new AxisAlignedBB(pos).func_72314_b((double)(bound * (1 - Math.abs(sideHit.func_82601_c()))), (double)(bound * (1 - Math.abs(sideHit.func_96559_d()))), (double)(bound * (1 - Math.abs(sideHit.func_82599_e()))));
                                ExchangingModes.addConnectedCoords(world, pos, currentBlock, setBlock, fuzzyMode, coordinates, (int)area.field_72340_a, (int)area.field_72338_b, (int)area.field_72339_c, (int)area.field_72336_d - 1, (int)area.field_72337_e - 1, (int)area.field_72334_f - 1);
                            } else if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                                for (int x = bound * -1; x <= bound; ++x) {
                                    for (z = bound * -1; z <= bound; ++z) {
                                        pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                        if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                        coordinates.add(pos);
                                    }
                                }
                            } else {
                                for (int y = bound; y >= bound * -1; --y) {
                                    for (int x = boundXS * -1; x <= boundXS; ++x) {
                                        for (int z2 = boundZS * -1; z2 <= boundZS; ++z2) {
                                            pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() - y, startBlock.func_177952_p() + z2);
                                            if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                }
                            }
                        }
                        if (mode == GadgetExchanger.ToolMode.VerticalColumn) {
                            if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                                for (int x = boundZ * -1; x <= boundZ; ++x) {
                                    for (z = boundX * -1; z <= boundX; ++z) {
                                        pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                        if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                        coordinates.add(pos);
                                    }
                                }
                            } else {
                                for (int y = bound; y >= bound * -1; --y) {
                                    pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - y, startBlock.func_177952_p());
                                    if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                    coordinates.add(pos);
                                }
                            }
                        }
                        if (mode != GadgetExchanger.ToolMode.HorizontalColumn) break block27;
                        if (sideHit != EnumFacing.UP && sideHit != EnumFacing.DOWN) break block28;
                        for (int x = boundX * -1; x <= boundX; ++x) {
                            for (z = boundZ * -1; z <= boundZ; ++z) {
                                pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                                coordinates.add(pos);
                            }
                        }
                        break block29;
                    }
                    if (sideHit != EnumFacing.NORTH && sideHit != EnumFacing.SOUTH) break block30;
                    for (int x = bound * -1; x <= bound; ++x) {
                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p());
                        if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                        coordinates.add(pos);
                    }
                    break block29;
                }
                if (sideHit != EnumFacing.EAST && sideHit != EnumFacing.WEST) break block29;
                for (int z3 = bound * -1; z3 <= bound; ++z3) {
                    pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), startBlock.func_177952_p() + z3);
                    if (!ExchangingModes.isReplaceable(world, pos, currentBlock, setBlock, fuzzyMode)) continue;
                    coordinates.add(pos);
                }
                break block29;
            }
            if (mode == GadgetExchanger.ToolMode.Grid) {
                for (int x = ++range * -7 / 5; x <= range * 7 / 5; ++x) {
                    for (z = range * -7 / 5; z <= range * 7 / 5; ++z) {
                        if (x % ((range - 2) % 6 + 2) != 0 || z % ((range - 2) % 6 + 2) != 0 || !ExchangingModes.isReplaceable(world, pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p() + z), currentBlock, setBlock, fuzzyMode)) continue;
                        coordinates.add(pos);
                    }
                }
            }
        }
        return coordinates;
    }
}

