/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.tools.BlockMap;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import it.unimi.dsi.fastutil.doubles.Double2ObjectArrayMap;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleRBTreeSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BuildingModes {
    private static boolean isReplaceable(World world, BlockPos pos, IBlockState setBlock) {
        if (!setBlock.func_177230_c().func_176196_c(world, pos)) {
            return false;
        }
        if (pos.func_177956_o() < 0) {
            return false;
        }
        return !(SyncedConfig.canOverwriteBlocks ? !world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) : world.func_180495_p(pos).func_185904_a() != Material.field_151579_a);
    }

    public static List<BlockPos> getBuildOrders(World world, EntityPlayer player, BlockPos startBlock, EnumFacing sideHit, ItemStack tool) {
        ArrayList<BlockPos> coordinates;
        block67: {
            int bound;
            int offset;
            boolean onTop;
            BlockPos pos;
            int range;
            IBlockState setBlock;
            GadgetBuilding.ToolMode mode;
            block79: {
                block82: {
                    block81: {
                        block80: {
                            EnumFacing playerFacing;
                            block78: {
                                block74: {
                                    block77: {
                                        block76: {
                                            block75: {
                                                block73: {
                                                    block72: {
                                                        int boundZ;
                                                        int boundX;
                                                        block65: {
                                                            BlockPos playerPos;
                                                            block71: {
                                                                block70: {
                                                                    block69: {
                                                                        block68: {
                                                                            block66: {
                                                                                mode = GadgetBuilding.getToolMode(tool);
                                                                                setBlock = GadgetUtils.getToolBlock(tool);
                                                                                range = GadgetUtils.getToolRange(tool);
                                                                                coordinates = new ArrayList<BlockPos>();
                                                                                playerPos = new BlockPos(Math.floor(player.field_70165_t), Math.floor(player.field_70163_u), Math.floor(player.field_70161_v));
                                                                                pos = startBlock;
                                                                                onTop = GadgetBuilding.shouldPlaceAtop(tool);
                                                                                int n = offset = onTop ? 1 : 0;
                                                                                if (mode != GadgetBuilding.ToolMode.BuildToMe && mode != GadgetBuilding.ToolMode.Grid && mode != GadgetBuilding.ToolMode.Surface) {
                                                                                    range -= 1 - offset;
                                                                                }
                                                                                bound = (range - 1) / 2;
                                                                                playerFacing = player.func_174811_aO();
                                                                                if (playerFacing == EnumFacing.SOUTH || playerFacing == EnumFacing.NORTH) {
                                                                                    boundX = bound;
                                                                                    boundZ = 0;
                                                                                } else {
                                                                                    boundX = 0;
                                                                                    boundZ = bound;
                                                                                }
                                                                                if (mode != GadgetBuilding.ToolMode.BuildToMe) break block65;
                                                                                if (sideHit != EnumFacing.SOUTH) break block66;
                                                                                for (int i = startBlock.func_177952_p() + offset; i <= playerPos.func_177952_p() - 1; ++i) {
                                                                                    pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), i);
                                                                                    if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                                    coordinates.add(pos);
                                                                                }
                                                                                break block67;
                                                                            }
                                                                            if (sideHit != EnumFacing.NORTH) break block68;
                                                                            for (int i = startBlock.func_177952_p() - offset; i >= playerPos.func_177952_p() + 1; --i) {
                                                                                pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), i);
                                                                                if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                                coordinates.add(pos);
                                                                            }
                                                                            break block67;
                                                                        }
                                                                        if (sideHit != EnumFacing.EAST) break block69;
                                                                        for (int i = startBlock.func_177958_n() + offset; i <= playerPos.func_177958_n() - 1; ++i) {
                                                                            pos = new BlockPos(i, startBlock.func_177956_o(), startBlock.func_177952_p());
                                                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                            coordinates.add(pos);
                                                                        }
                                                                        break block67;
                                                                    }
                                                                    if (sideHit != EnumFacing.WEST) break block70;
                                                                    for (int i = startBlock.func_177958_n() - offset; i >= playerPos.func_177958_n() + 1; --i) {
                                                                        pos = new BlockPos(i, startBlock.func_177956_o(), startBlock.func_177952_p());
                                                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                        coordinates.add(pos);
                                                                    }
                                                                    break block67;
                                                                }
                                                                if (sideHit != EnumFacing.UP) break block71;
                                                                for (int i = startBlock.func_177956_o() + offset; i <= playerPos.func_177956_o() - 1; ++i) {
                                                                    pos = new BlockPos(startBlock.func_177958_n(), i, startBlock.func_177952_p());
                                                                    if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                    coordinates.add(pos);
                                                                }
                                                                break block67;
                                                            }
                                                            if (sideHit != EnumFacing.DOWN) break block67;
                                                            for (int i = startBlock.func_177956_o() - offset; i >= playerPos.func_177956_o() + 1; --i) {
                                                                pos = new BlockPos(startBlock.func_177958_n(), i, startBlock.func_177952_p());
                                                                if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                coordinates.add(pos);
                                                            }
                                                            break block67;
                                                        }
                                                        if (mode != GadgetBuilding.ToolMode.VerticalWall) break block72;
                                                        if (sideHit == EnumFacing.UP) {
                                                            for (int y = offset; y <= range; ++y) {
                                                                for (int x = -boundX; x <= boundX; ++x) {
                                                                    for (int z = -boundZ; z <= boundZ; ++z) {
                                                                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() + y, startBlock.func_177952_p() + z);
                                                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                        coordinates.add(pos);
                                                                    }
                                                                }
                                                            }
                                                        } else if (sideHit == EnumFacing.DOWN) {
                                                            for (int y = offset; y <= range; ++y) {
                                                                for (int x = -boundX; x <= boundX; ++x) {
                                                                    for (int z = -boundZ; z <= boundZ; ++z) {
                                                                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() - y, startBlock.func_177952_p() + z);
                                                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                        coordinates.add(pos);
                                                                    }
                                                                }
                                                            }
                                                        } else {
                                                            for (int y = bound; y >= -bound; --y) {
                                                                for (int x = -boundX; x <= boundX; ++x) {
                                                                    for (int z = -boundZ; z <= boundZ; ++z) {
                                                                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() - y, startBlock.func_177952_p() + z);
                                                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                                        coordinates.add(pos);
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        break block67;
                                                    }
                                                    if (mode != GadgetBuilding.ToolMode.VerticalColumn) break block73;
                                                    if (sideHit == EnumFacing.UP) {
                                                        for (int y = offset; y <= range; ++y) {
                                                            pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + y, startBlock.func_177952_p());
                                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                            coordinates.add(pos);
                                                        }
                                                    } else if (sideHit == EnumFacing.DOWN) {
                                                        for (int y = offset; y <= range; ++y) {
                                                            pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - y, startBlock.func_177952_p());
                                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                            coordinates.add(pos);
                                                        }
                                                    } else {
                                                        for (int y = -bound; y <= bound; ++y) {
                                                            pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - y, startBlock.func_177952_p());
                                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                            coordinates.add(pos);
                                                        }
                                                    }
                                                    break block67;
                                                }
                                                if (mode != GadgetBuilding.ToolMode.HorizontalColumn) break block74;
                                                if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                                                    sideHit = playerFacing.func_176734_d();
                                                }
                                                if (sideHit != EnumFacing.NORTH) break block75;
                                                for (int z = offset; z <= range; ++z) {
                                                    pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                                    if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                    coordinates.add(pos);
                                                }
                                                break block67;
                                            }
                                            if (sideHit != EnumFacing.SOUTH) break block76;
                                            for (int z = offset; z <= range; ++z) {
                                                pos = new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o(), startBlock.func_177952_p() - z);
                                                if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                                coordinates.add(pos);
                                            }
                                            break block67;
                                        }
                                        if (sideHit != EnumFacing.EAST) break block77;
                                        for (int x = offset; x <= range; ++x) {
                                            pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p());
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                        break block67;
                                    }
                                    if (sideHit != EnumFacing.WEST) break block67;
                                    for (int x = offset; x <= range; ++x) {
                                        pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p());
                                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                        coordinates.add(pos);
                                    }
                                    break block67;
                                }
                                if (mode != GadgetBuilding.ToolMode.HorizontalWall) break block78;
                                if (sideHit == EnumFacing.NORTH) {
                                    for (int z = offset; z <= range; ++z) {
                                        for (int x = -bound; x <= bound; ++x) {
                                            pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p() - z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                } else if (sideHit == EnumFacing.SOUTH) {
                                    for (int z = offset; z <= range; ++z) {
                                        for (int x = -bound; x <= bound; ++x) {
                                            pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                } else if (sideHit == EnumFacing.EAST) {
                                    for (int x = offset; x <= range; ++x) {
                                        for (int z = -bound; z <= bound; ++z) {
                                            pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                } else if (sideHit == EnumFacing.WEST) {
                                    for (int x = offset; x <= range; ++x) {
                                        for (int z = -bound; z <= bound; ++z) {
                                            pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                } else {
                                    for (int x = -bound; x <= bound; ++x) {
                                        for (int z = -bound; z <= bound; ++z) {
                                            pos = new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o(), startBlock.func_177952_p() + z);
                                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                            coordinates.add(pos);
                                        }
                                    }
                                }
                                break block67;
                            }
                            if (mode != GadgetBuilding.ToolMode.Stairs) break block79;
                            if (sideHit == EnumFacing.UP || sideHit == EnumFacing.DOWN) {
                                sideHit = playerFacing.func_176734_d();
                            }
                            if (sideHit != EnumFacing.NORTH) break block80;
                            for (int z = offset; z <= range; ++z) {
                                pos = (double)startBlock.func_177956_o() > player.field_70163_u + 1.0 ? new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - z, startBlock.func_177952_p() - z) : ((double)startBlock.func_177956_o() < player.field_70163_u - 2.0 ? new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + z, startBlock.func_177952_p() - z + offset) : new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + z, startBlock.func_177952_p() + z - offset));
                                if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                                coordinates.add(pos);
                            }
                            break block67;
                        }
                        if (sideHit != EnumFacing.SOUTH) break block81;
                        for (int z = offset; z <= range; ++z) {
                            pos = (double)startBlock.func_177956_o() > player.field_70163_u + 1.0 ? new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() - z, startBlock.func_177952_p() + z) : ((double)startBlock.func_177956_o() < player.field_70163_u - 2.0 ? new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + z, startBlock.func_177952_p() + z - offset) : new BlockPos(startBlock.func_177958_n(), startBlock.func_177956_o() + z, startBlock.func_177952_p() - z + offset));
                            if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                            coordinates.add(pos);
                        }
                        break block67;
                    }
                    if (sideHit != EnumFacing.EAST) break block82;
                    for (int x = offset; x <= range; ++x) {
                        pos = (double)startBlock.func_177956_o() > player.field_70163_u + 1.0 ? new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() - x, startBlock.func_177952_p()) : ((double)startBlock.func_177956_o() < player.field_70163_u - 2.0 ? new BlockPos(startBlock.func_177958_n() + x - offset, startBlock.func_177956_o() + x, startBlock.func_177952_p()) : new BlockPos(startBlock.func_177958_n() - x + offset, startBlock.func_177956_o() + x, startBlock.func_177952_p()));
                        if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                        coordinates.add(pos);
                    }
                    break block67;
                }
                if (sideHit != EnumFacing.WEST) break block67;
                for (int x = offset; x <= range; ++x) {
                    pos = (double)startBlock.func_177956_o() > player.field_70163_u + 1.0 ? new BlockPos(startBlock.func_177958_n() - x, startBlock.func_177956_o() - x, startBlock.func_177952_p()) : ((double)startBlock.func_177956_o() < player.field_70163_u - 2.0 ? new BlockPos(startBlock.func_177958_n() - x + offset, startBlock.func_177956_o() + x, startBlock.func_177952_p()) : new BlockPos(startBlock.func_177958_n() + x - offset, startBlock.func_177956_o() + x, startBlock.func_177952_p()));
                    if (!BuildingModes.isReplaceable(world, pos, setBlock)) continue;
                    coordinates.add(pos);
                }
                break block67;
            }
            if (mode == GadgetBuilding.ToolMode.Grid) {
                for (int x = ++range * -7 / 5; x <= range * 7 / 5; ++x) {
                    for (int z = range * -7 / 5; z <= range * 7 / 5; ++z) {
                        if (x % ((range - 2) % 6 + 2) != 0 || z % ((range - 2) % 6 + 2) != 0 || !BuildingModes.isReplaceable(world, pos = new BlockPos(startBlock.func_177958_n() + x, startBlock.func_177956_o() + offset, startBlock.func_177952_p() + z), setBlock)) continue;
                        coordinates.add(pos);
                    }
                }
            } else if (mode == GadgetBuilding.ToolMode.Surface) {
                IBlockState startState = world.func_180495_p(startBlock);
                AxisAlignedBB area = new AxisAlignedBB(pos).func_72314_b((double)(bound * (1 - Math.abs(sideHit.func_82601_c()))), (double)(bound * (1 - Math.abs(sideHit.func_96559_d()))), (double)(bound * (1 - Math.abs(sideHit.func_82599_e()))));
                boolean fuzzyMode = GadgetGeneric.getFuzzy(tool);
                if (GadgetGeneric.getConnectedArea(tool)) {
                    BuildingModes.addConnectedCoords(world, pos, onTop, startState, setBlock, sideHit, fuzzyMode, coordinates, new HashSet<BlockPos>(), (int)area.field_72340_a, (int)area.field_72338_b, (int)area.field_72339_c, (int)area.field_72336_d - 1, (int)area.field_72337_e - 1, (int)area.field_72334_f - 1);
                } else {
                    for (BlockPos loc : BlockPos.func_191532_a((int)((int)area.field_72340_a), (int)((int)area.field_72338_b), (int)((int)area.field_72339_c), (int)((int)area.field_72336_d - 1), (int)((int)area.field_72337_e - 1), (int)((int)area.field_72334_f - 1))) {
                        BlockPos locOffset;
                        BlockPos blockPos = locOffset = onTop ? loc.func_177972_a(sideHit) : loc;
                        if (!(fuzzyMode ? !world.func_175623_d(loc) : world.func_180495_p(loc) == startState) || !BuildingModes.isReplaceable(world, locOffset, setBlock)) continue;
                        coordinates.add(locOffset);
                    }
                }
            }
        }
        return coordinates;
    }

    private static void addConnectedCoords(World world, BlockPos loc, boolean onTop, IBlockState state, IBlockState setBlock, EnumFacing sideHit, boolean fuzzyMode, List<BlockPos> coords, Set<BlockPos> coordsSearched, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        BlockPos locOffset;
        if (coordsSearched.contains(loc) || loc.func_177958_n() < minX || loc.func_177956_o() < minY || loc.func_177952_p() < minZ || loc.func_177958_n() > maxX || loc.func_177956_o() > maxY || loc.func_177952_p() > maxZ) {
            return;
        }
        BlockPos blockPos = locOffset = onTop ? loc.func_177972_a(sideHit) : loc;
        if ((!fuzzyMode ? world.func_180495_p(loc) != state : world.func_175623_d(loc)) || !BuildingModes.isReplaceable(world, locOffset, setBlock)) {
            return;
        }
        coords.add(locOffset);
        coordsSearched.add(loc);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BuildingModes.addConnectedCoords(world, loc.func_177982_a(x, y, z), onTop, state, setBlock, sideHit, fuzzyMode, coords, coordsSearched, minX, minY, minZ, maxX, maxY, maxZ);
                }
            }
        }
    }

    public static List<BlockMap> sortMapByDistance(List<BlockMap> unSortedMap, EntityPlayer player) {
        ArrayList<BlockPos> unSortedList = new ArrayList<BlockPos>();
        HashMap<BlockPos, IBlockState> PosToStateMap = new HashMap<BlockPos, IBlockState>();
        HashMap<BlockPos, Integer> PosToX = new HashMap<BlockPos, Integer>();
        HashMap<BlockPos, Integer> PosToY = new HashMap<BlockPos, Integer>();
        HashMap<BlockPos, Integer> PosToZ = new HashMap<BlockPos, Integer>();
        for (BlockMap blockMap : unSortedMap) {
            PosToStateMap.put(blockMap.pos, blockMap.state);
            PosToX.put(blockMap.pos, blockMap.xOffset);
            PosToY.put(blockMap.pos, blockMap.yOffset);
            PosToZ.put(blockMap.pos, blockMap.zOffset);
            unSortedList.add(blockMap.pos);
        }
        ArrayList<BlockMap> sortedMap = new ArrayList<BlockMap>();
        Double2ObjectArrayMap rangeMap = new Double2ObjectArrayMap(unSortedList.size());
        DoubleRBTreeSet distances = new DoubleRBTreeSet();
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        for (BlockPos pos : unSortedList) {
            double distance = pos.func_177957_d(x, y, z);
            rangeMap.put(distance, (Object)pos);
            distances.add(distance);
        }
        DoubleBidirectionalIterator doubleBidirectionalIterator = distances.iterator();
        while (doubleBidirectionalIterator.hasNext()) {
            double dist = (Double)doubleBidirectionalIterator.next();
            BlockPos pos = new BlockPos((Vec3i)rangeMap.get(dist));
            sortedMap.add(new BlockMap(pos, (IBlockState)PosToStateMap.get(pos), (Integer)PosToX.get(pos), (Integer)PosToY.get(pos), (Integer)PosToZ.get(pos)));
        }
        return sortedMap;
    }
}

