/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.pastes;

import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.pastes.GenericPasteContainer;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.NBTTool;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConstructionPasteContainer
extends GenericPasteContainer {
    private IntSupplier maxCapacity;

    public ConstructionPasteContainer(String suffix, IntSupplier maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.setRegistryName("constructionpastecontainer" + suffix);
        this.func_77655_b("buildinggadgets.constructionpastecontainer" + suffix);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(this.getRegistryName(), "inventory"), new ModelResourceLocation(this.getRegistryName() + "-half", "inventory"), new ModelResourceLocation(this.getRegistryName() + "-full", "inventory"), new ModelResourceLocation(this.getRegistryName() + "-quarter", "inventory"), new ModelResourceLocation(this.getRegistryName() + "-3quarter", "inventory")});
    }

    @Override
    public void setPasteCount(ItemStack stack, int amount) {
        NBTTool.getOrNewTag(stack).func_74768_a("amount", amount);
    }

    @Override
    public int getPasteCount(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("amount");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        player.func_184598_c(hand);
        InventoryPlayer inv = player.field_71071_by;
        if (!world.field_72995_K) {
            for (int i = 0; i < 36; ++i) {
                ItemStack itemStack = inv.func_70301_a(i);
                if (!(itemStack.func_77973_b() instanceof ConstructionPaste)) continue;
                InventoryManipulation.addPasteToContainer(player, itemStack);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag b) {
        list.add(ConstructionPasteContainer.getAmountDisplayLocalized() + ": " + ConstructionPasteContainer.getPasteAmount(stack));
    }

    @Override
    public int getMaxCapacity() {
        return this.maxCapacity.getAsInt();
    }
}

