/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.proxy;

import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.ForgeEventHandlers;
import mcjty.deepresonance.blocks.ModBlocks;
import mcjty.deepresonance.blocks.generator.GeneratorConfiguration;
import mcjty.deepresonance.blocks.laser.LaserBonusConfiguration;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.gui.GuiProxy;
import mcjty.deepresonance.items.ModItems;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.deepresonance.radiation.RadiationTickEvent;
import mcjty.deepresonance.radiation.SuperGenerationConfiguration;
import mcjty.deepresonance.worldgen.WorldGen;
import mcjty.deepresonance.worldgen.WorldGenConfiguration;
import mcjty.deepresonance.worldgen.WorldTickHandler;
import mcjty.lib.network.PacketHandler;
import mcjty.lib.proxy.AbstractCommonProxy;
import mcjty.lib.varia.WrenchChecker;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy
extends AbstractCommonProxy {
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
        this.mainConfig = DeepResonance.config;
        this.readMainConfig();
        SimpleNetworkWrapper network = PacketHandler.registerMessages((String)"deepresonance", (String)"deepresonance");
        DRMessages.registerNetworkMessages(network);
        ModItems.init();
        ModBlocks.init();
        WorldGen.init();
        DRFluidRegistry.initFluids();
    }

    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            cfg.load();
            cfg.addCustomCategoryComment("worldgen", "Configuration for worldgen");
            cfg.addCustomCategoryComment("generator", "Configuration for the generator multiblock");
            cfg.addCustomCategoryComment("radiation", "Configuration for the radiation");
            cfg.addCustomCategoryComment("laserconfig", "Configuration for the laser bonuses");
            cfg.addCustomCategoryComment("supergen", "Configuration for super power generation (using pulser)");
            WorldGenConfiguration.init(cfg);
            GeneratorConfiguration.init(cfg);
            RadiationConfiguration.init(cfg);
            LaserBonusConfiguration.init(cfg);
            SuperGenerationConfiguration.init(cfg);
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            if (this.mainConfig.hasChanged()) {
                this.mainConfig.save();
            }
        }
    }

    public void init(FMLInitializationEvent e) {
        super.init(e);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)DeepResonance.instance, (IGuiHandler)new GuiProxy());
        MinecraftForge.EVENT_BUS.register((Object)WorldTickHandler.instance);
        MinecraftForge.EVENT_BUS.register((Object)new RadiationTickEvent());
    }

    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
        this.mainConfig = null;
        WrenchChecker.init();
    }

    public abstract void throwException(Exception var1, int var2);
}

