/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.network;

import io.netty.buffer.ByteBuf;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.fluid.DRFluidRegistry;
import mcjty.deepresonance.network.DRMessages;
import mcjty.deepresonance.network.PacketReturnTankInfo;
import mcjty.lib.network.NetworkTools;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketGetTankInfo
implements IMessage {
    private BlockPos pos;

    public void fromBytes(ByteBuf buf) {
        this.pos = NetworkTools.readPos((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
    }

    public PacketGetTankInfo() {
    }

    public PacketGetTankInfo(BlockPos pos) {
        this.pos = pos;
    }

    public static class Handler
    implements IMessageHandler<PacketGetTankInfo, IMessage> {
        public IMessage onMessage(PacketGetTankInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketGetTankInfo message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.func_130014_f_();
            TileEntity tileEntity = world.func_175625_s(message.pos);
            if (tileEntity instanceof TileTank) {
                TileTank tileTank = (TileTank)tileEntity;
                PacketReturnTankInfo packet = new PacketReturnTankInfo(tileTank.getFluidAmount(), tileTank.getCapacity(), DRFluidRegistry.getFluidName(tileTank.getFluid()), tileTank.getFluidTag());
                DRMessages.INSTANCE.sendTo((IMessage)packet, ctx.getServerHandler().field_147369_b);
            }
        }
    }
}

