/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.jei.laser;

import javax.annotation.Nonnull;
import mcjty.deepresonance.blocks.laser.InfusingBonus;
import mcjty.deepresonance.blocks.laser.LaserTileEntity;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LaserRecipeWrapper
extends BlankRecipeWrapper {
    private final Item item;

    public LaserRecipeWrapper(Item item) {
        this.item = item;
    }

    public Item getItem() {
        return this.item;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)new ItemStack(this.item));
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        InfusingBonus bonus = LaserTileEntity.infusingBonusMap.get(this.item.getRegistryName().toString());
        this.renderStat("Purity:", bonus.getPurityModifier(), 30);
        this.renderStat("Strength:", bonus.getStrengthModifier(), 40);
        this.renderStat("Efficiency:", bonus.getEfficiencyModifier(), 50);
    }

    private void renderStat(String label, InfusingBonus.Modifier modifier, int y) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_175065_a(label, 0.0f, (float)y, -1, true);
        float purityBonus = modifier.getBonus();
        fontRenderer.func_175065_a(String.valueOf(purityBonus) + "%", 60.0f, (float)y, purityBonus > 0.0f ? -16751104 : -65536, false);
        fontRenderer.func_175065_a("(" + String.valueOf(modifier.getMaxOrMin()) + ")", 100.0f, (float)y, -16777216, false);
    }
}

