/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.items.rftoolsmodule;

import elec332.core.world.WorldHelper;
import mcjty.deepresonance.items.RadiationMonitorItem;
import mcjty.deepresonance.items.rftoolsmodule.RFToolsSupport;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.rftools.api.screens.IScreenDataHelper;
import mcjty.rftools.api.screens.IScreenModule;
import mcjty.rftools.api.screens.data.IModuleDataInteger;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class RadiationScreenModule
implements IScreenModule<IModuleDataInteger> {
    private int dim = 0;
    private BlockPos coordinate = BlockPosTools.INVALID;

    public IModuleDataInteger getData(IScreenDataHelper h, World worldObj, long millis) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldHelper.chunkLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        Block block = world.func_180495_p(this.coordinate).func_177230_c();
        if (block != RFToolsSupport.radiationSensorBlock) {
            return null;
        }
        float strength = RadiationMonitorItem.calculateRadiationStrength((World)world, new GlobalCoordinate(this.coordinate, this.dim));
        return h.createInteger((int)strength);
    }

    public void setupFromNBT(NBTTagCompound tagCompound, int dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("monitorx")) {
                this.dim = tagCompound.func_74764_b("monitordim") ? tagCompound.func_74762_e("monitordim") : tagCompound.func_74762_e("dim");
                if (dim == this.dim) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 256 && dy <= 256 && dz <= 256) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return RadiationConfiguration.RADIATIONMODULE_RFPERTICK;
    }

    public void mouseClick(World world, int x, int y, boolean clicked, EntityPlayer player) {
    }
}

