/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.config;

import net.minecraftforge.common.config.Config;

@Config(modid="deepresonance", name="deepresonance/machines", category="")
public class ConfigMachines {
    public static General general = new General();
    public static PlateBlock plateBlock = new PlateBlock();
    public static Pulser pulser = new Pulser();
    public static Purifier purifier = new Purifier();
    public static Smelter smelter = new Smelter();
    public static Crystalizer crystalizer = new Crystalizer();
    public static Collector collector = new Collector();
    public static Valve valve = new Valve();
    public static Laser laser = new Laser();
    public static Power power = new Power();

    public static class Power {
        @Config.RangeInt(min=1, max=2000000000)
        @Config.Comment(value={"The maximum kilo-RF (per 1000, so 1000 = 1milion RF) that a crystal with 100% power can hold"})
        public int maximumKiloRF = 1000000;
        @Config.RangeInt(min=0, max=20000)
        @Config.Comment(value={"The maximum RF/tick that a crystal with 100% efficiency can give"})
        public int maximumRFPerTick = 20000;
    }

    public static class Laser {
        @Config.RangeInt(min=0, max=50000)
        @Config.Comment(value={"How much RF/t this machine can input from a generator/capacitor"})
        public int rfPerTick = 2000;
        @Config.RangeInt(min=0, max=50000)
        @Config.Comment(value={"How much RF this machine consumes for infusing one catalyst item"})
        public int rfUsePerCatalyst = 4000;
        @Config.RangeInt(min=0, max=10000)
        @Config.Comment(value={"How many multiples of 10 ticks are needed to infuse one catalyst item"})
        public int ticks10PerCatalyst = 4;
        @Config.RangeInt(min=0, max=1000000000)
        @Config.Comment(value={"Maximum RF that can be stored in this machine"})
        public int rfMaximum = 100000;
        @Config.RangeInt(min=1, max=100000000)
        @Config.Comment(value={"The maximum amount of liquified crystal this machine can hold (this is not RCL!)"})
        public int crystalLiquidMaximum = 20000;
        @Config.RangeInt(min=1, max=10000000)
        @Config.Comment(value={"The minimum amount of liquified crystal one crystal will yield (this is not RCL!). This value is for a 0% strength crystal"})
        public int minCrystalLiquidPerCrystal = 2000;
        @Config.RangeInt(min=1, max=10000000)
        @Config.Comment(value={"The maximum amount of liquified crystal one crystal will yield (this is not RCL!). This value is for a 100% strength crystal"})
        public int maxCrystalLiquidPerCrystal = 10000;
        @Config.RangeInt(min=1, max=10000000)
        @Config.Comment(value={"The amount of RCL we improve with one catalyst item"})
        public int rclPerCatalyst = 500;
        @Config.RangeInt(min=1, max=10000000)
        @Config.Comment(value={"The amount of crystal liquid we consume per catalyst item"})
        public int crystalLiquidPerCatalyst = 25;
    }

    public static class Valve {
        @Config.RangeInt(min=1, max=10000)
        @Config.Comment(value={"Amount of ticks needed to transfer one unit of RCL"})
        public int ticksPerOperation = 5;
        @Config.RangeInt(min=1, max=10000)
        @Config.Comment(value={"The amount of RCL we process in one operation"})
        public int rclPerOperation = 100;
    }

    public static class Collector {
        @Config.RangeInt(min=1, max=16)
        @Config.Comment(value={"Maximum horizontal distance to look for crystals"})
        public int maxHorizontalCrystalDistance = 10;
        @Config.RangeInt(min=1, max=16)
        @Config.Comment(value={"Maximum vertical distance to look for crystals"})
        public int maxVerticalCrystalDistance = 1;
    }

    public static class Crystalizer {
        @Config.RangeInt(min=0, max=1000)
        @Config.Comment(value={"How much RF/t this machine can input from a generator/capacitor"})
        public int rfPerTick = 200;
        @Config.RangeInt(min=0, max=1000)
        @Config.Comment(value={"How much RF this machine consumes for one crystalizing step"})
        public int rfPerRcl = 20;
        @Config.RangeInt(min=0, max=1000000000)
        @Config.Comment(value={"Maximum RF that can be stored in this machine"})
        public int rfMaximum = 50000;
        @Config.RangeInt(min=10, max=100000)
        @Config.Comment(value={"The amount of RCL that is needed for one crystal"})
        public int rclPerCrystal = 6000;
        @Config.RangeInt(min=1, max=100000)
        @Config.Comment(value={"The amount of RCL/t that is consumed during crystalizing"})
        public int rclPerTick = 1;
    }

    public static class Smelter {
        @Config.RangeInt(min=0, max=1000)
        @Config.Comment(value={"How much RF/t this machine can input from a generator/capacitor"})
        public int rfPerTick = 200;
        @Config.RangeInt(min=0, max=1000)
        @Config.Comment(value={"How much RF/t this machine consumes during smelting ores"})
        public int rfPerOre = 10;
        @Config.RangeInt(min=0, max=1000000000)
        @Config.Comment(value={"Maximum RF that can be stored in this machine"})
        public int rfMaximum = 50000;
        @Config.RangeInt(min=10, max=1000)
        @Config.Comment(value={"The number of ticks to smelt one ore"})
        public int processTime = 200;
        @Config.RangeInt(min=100, max=10000)
        @Config.Comment(value={"The amount of lava to smelt one ore"})
        public int lavaCost = 200;
        @Config.RangeInt(min=50, max=1000)
        @Config.Comment(value={"The amount of RCL to produce with one ore"})
        public int rclPerOre = 200;
    }

    public static class Purifier {
        @Config.RangeInt(min=1, max=10000)
        @Config.Comment(value={"Amount of ticks needed to purify one unit of RCL"})
        public int ticksPerPurify = 100;
        @Config.RangeInt(min=1, max=10000)
        @Config.Comment(value={"The amount of RCL we purify as one unit"})
        public int rclPerPurify = 200;
        @Config.RangeInt(min=1, max=100)
        @Config.Comment(value={"How much the purifier adds to the purity of a liquid (in %)"})
        public int addedPurity = 25;
        @Config.RangeInt(min=1, max=100)
        @Config.Comment(value={"Maximum purity that the purifier can handle (in %)"})
        public int maxPurity = 85;
    }

    public static class Pulser {
        @Config.RangeInt(min=0, max=1000)
        @Config.Comment(value={"How much RF/t this machine can input from a generator/capacitor"})
        public int rfPerTick = 100;
        @Config.RangeInt(min=0, max=1000000000)
        @Config.Comment(value={"Maximum RF that can be stored in this machine"})
        public int rfMaximum = 100;
        @Config.RangeInt(min=1, max=100000)
        @Config.Comment(value={"The RF needed for a single pulse (should be a multiple of 15!)"})
        public int rfPerPulse = 60;
    }

    public static class PlateBlock {
        @Config.RangeInt(min=0, max=100000)
        @Config.Comment(value={"Strength of radiation that a plate block gives when it has a redstone signal. 0 to disable"})
        public int radiationStrength = 20000;
        @Config.RangeInt(min=0, max=100000)
        @Config.Comment(value={"Radius of radiation that a plate block gives when it has a redstone signal"})
        public int radiationRadius = 10;
        @Config.RangeInt(min=0, max=100000)
        @Config.Comment(value={"Amount of ticks that the radiation lasts from a plate block"})
        public int radiationTicks = 100;
    }

    public static class General {
        @Config.Comment(value={"Experimental fix for weird behaviour of machines that interact with DR tanks."})
        public boolean experimentalChunkBorderFix = true;
    }
}

