/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.compat.rftoolscontrol;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.deepresonance.blocks.crystals.ResonatingCrystalTileEntity;
import mcjty.deepresonance.blocks.laser.LaserTileEntity;
import mcjty.deepresonance.blocks.tank.TileTank;
import mcjty.deepresonance.fluid.LiquidCrystalFluidTagData;
import mcjty.rftoolscontrol.api.code.IOpcodeRunnable;
import mcjty.rftoolscontrol.api.code.Opcode;
import mcjty.rftoolscontrol.api.code.OpcodeOutput;
import mcjty.rftoolscontrol.api.parameters.BlockSide;
import mcjty.rftoolscontrol.api.parameters.Inventory;
import mcjty.rftoolscontrol.api.parameters.Parameter;
import mcjty.rftoolscontrol.api.parameters.ParameterDescription;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.api.registry.IOpcodeRegistry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;

public class RFToolsControlSupport {
    public static final Opcode EVAL_READPURITY = Opcode.builder().id("deepresonance:read_purity").description(new String[]{TextFormatting.GREEN + "Eval: read purity (Deep Resonance)", "read purity of the RCL liquid in a tank", "adjacent to the processor or a connected node", "This opcode returns -1 if the tank is not a", "tank or does not contain RCL"}).outputDescription("purity between 0 and 100 (integer)").opcodeOutput(OpcodeOutput.SINGLE).parameter(ParameterDescription.builder().name("tank").type(ParameterType.PAR_INVENTORY).description(new String[]{"tank adjacent to (networked) block"}).build()).icon(0, 5, "deepresonance:textures/gui/guielements.png").runnable((processor, program, opcode) -> {
        TileTank tank;
        LiquidCrystalFluidTagData lcd;
        Inventory inv = (Inventory)processor.evaluateParameter(opcode, program, 0);
        TileEntity te = processor.getTileEntityAt((BlockSide)inv);
        int purity = -1;
        if (te instanceof TileTank && (lcd = LiquidCrystalFluidTagData.fromStack((tank = (TileTank)te).getFluid())) != null) {
            purity = (int)(lcd.getPurity() * 100.0f + 0.5f);
        }
        program.setLastValue(Parameter.builder().type(ParameterType.PAR_INTEGER).value(ParameterValue.constant((Object)purity)).build());
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }).build();
    public static final Opcode EVAL_READSTRENGTH = Opcode.builder().id("deepresonance:read_strength").description(new String[]{TextFormatting.GREEN + "Eval: read strength (Deep Resonance)", "read strength of the RCL liquid in a tank", "adjacent to the processor or a connected node", "This opcode returns -1 if the tank is not a", "tank or does not contain RCL"}).outputDescription("strength between 0 and 100 (integer)").opcodeOutput(OpcodeOutput.SINGLE).parameter(ParameterDescription.builder().name("tank").type(ParameterType.PAR_INVENTORY).description(new String[]{"tank adjacent to (networked) block"}).build()).icon(1, 5, "deepresonance:textures/gui/guielements.png").runnable((processor, program, opcode) -> {
        TileTank tank;
        LiquidCrystalFluidTagData lcd;
        Inventory inv = (Inventory)processor.evaluateParameter(opcode, program, 0);
        TileEntity te = processor.getTileEntityAt((BlockSide)inv);
        int purity = -1;
        if (te instanceof TileTank && (lcd = LiquidCrystalFluidTagData.fromStack((tank = (TileTank)te).getFluid())) != null) {
            purity = (int)(lcd.getStrength() * 100.0f + 0.5f);
        }
        program.setLastValue(Parameter.builder().type(ParameterType.PAR_INTEGER).value(ParameterValue.constant((Object)purity)).build());
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }).build();
    public static final Opcode EVAL_READEFFICIENCY = Opcode.builder().id("deepresonance:read_efficiency").description(new String[]{TextFormatting.GREEN + "Eval: read efficiency (Deep Resonance)", "read efficiency of the RCL liquid in a tank", "adjacent to the processor or a connected node", "This opcode returns -1 if the tank is not a", "tank or does not contain RCL"}).outputDescription("efficiency between 0 and 100 (integer)").opcodeOutput(OpcodeOutput.SINGLE).parameter(ParameterDescription.builder().name("tank").type(ParameterType.PAR_INVENTORY).description(new String[]{"tank adjacent to (networked) block"}).build()).icon(2, 5, "deepresonance:textures/gui/guielements.png").runnable((processor, program, opcode) -> {
        TileTank tank;
        LiquidCrystalFluidTagData lcd;
        Inventory inv = (Inventory)processor.evaluateParameter(opcode, program, 0);
        TileEntity te = processor.getTileEntityAt((BlockSide)inv);
        int purity = -1;
        if (te instanceof TileTank && (lcd = LiquidCrystalFluidTagData.fromStack((tank = (TileTank)te).getFluid())) != null) {
            purity = (int)(lcd.getEfficiency() * 100.0f + 0.5f);
        }
        program.setLastValue(Parameter.builder().type(ParameterType.PAR_INTEGER).value(ParameterValue.constant((Object)purity)).build());
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }).build();
    public static final Opcode EVAL_READQUALITY = Opcode.builder().id("deepresonance:read_quality").description(new String[]{TextFormatting.GREEN + "Eval: read quality (Deep Resonance)", "read quality of the RCL liquid in a tank", "adjacent to the processor or a connected node", "This opcode returns -1 if the tank is not a", "tank or does not contain RCL"}).outputDescription("quality between 0 and 100 (integer)").opcodeOutput(OpcodeOutput.SINGLE).parameter(ParameterDescription.builder().name("tank").type(ParameterType.PAR_INVENTORY).description(new String[]{"tank adjacent to (networked) block"}).build()).icon(3, 5, "deepresonance:textures/gui/guielements.png").runnable((processor, program, opcode) -> {
        TileTank tank;
        LiquidCrystalFluidTagData lcd;
        Inventory inv = (Inventory)processor.evaluateParameter(opcode, program, 0);
        TileEntity te = processor.getTileEntityAt((BlockSide)inv);
        int purity = -1;
        if (te instanceof TileTank && (lcd = LiquidCrystalFluidTagData.fromStack((tank = (TileTank)te).getFluid())) != null) {
            purity = (int)(lcd.getQuality() * 100.0f + 0.5f);
        }
        program.setLastValue(Parameter.builder().type(ParameterType.PAR_INTEGER).value(ParameterValue.constant((Object)purity)).build());
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }).build();
    public static final Opcode EVAL_READPOWER = Opcode.builder().id("deepresonance:read_power").description(new String[]{TextFormatting.GREEN + "Eval: read power (Deep Resonance)", "read remaining power (in percentage between 0 and 100)", "of a crystal adjacent to the processor or a connected node", "Returns -1 if the block there is not a crystal"}).outputDescription("power between 0 and 100 (integer)").opcodeOutput(OpcodeOutput.SINGLE).parameter(ParameterDescription.builder().name("crystal").type(ParameterType.PAR_SIDE).description(new String[]{"crystal adjacent to (networked) block"}).build()).icon(4, 5, "deepresonance:textures/gui/guielements.png").runnable((processor, program, opcode) -> {
        BlockSide inv = processor.evaluateSideParameterNonNull(opcode, program, 0);
        TileEntity te = processor.getTileEntityAt(inv);
        int power = -1;
        if (te instanceof ResonatingCrystalTileEntity) {
            ResonatingCrystalTileEntity crystal = (ResonatingCrystalTileEntity)te;
            power = (int)crystal.getPower();
        }
        program.setLastValue(Parameter.builder().type(ParameterType.PAR_INTEGER).value(ParameterValue.constant((Object)power)).build());
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }).build();
    public static final Opcode EVAL_READLASER = Opcode.builder().id("deepresonance:read_laser").description(new String[]{TextFormatting.GREEN + "Eval: read laser (Deep Resonance)", "read the remaining crystal liquid in a laser", "adjacent to the processor or a connected node", "Returns -1 if the block there is not a laser"}).outputDescription("remaining crystal liquid in laser (integer)").opcodeOutput(OpcodeOutput.SINGLE).parameter(ParameterDescription.builder().name("laser").type(ParameterType.PAR_SIDE).description(new String[]{"laser adjacent to (networked) block"}).build()).icon(5, 5, "deepresonance:textures/gui/guielements.png").runnable((processor, program, opcode) -> {
        BlockSide inv = processor.evaluateSideParameterNonNull(opcode, program, 0);
        TileEntity te = processor.getTileEntityAt(inv);
        int crystal = -1;
        if (te instanceof LaserTileEntity) {
            LaserTileEntity laser = (LaserTileEntity)te;
            crystal = laser.getCrystalLiquid();
        }
        program.setLastValue(Parameter.builder().type(ParameterType.PAR_INTEGER).value(ParameterValue.constant((Object)crystal)).build());
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }).build();

    public static class GetOpcodeRegistry
    implements Function<IOpcodeRegistry, Void> {
        @Override
        @Nullable
        public Void apply(IOpcodeRegistry registry) {
            registry.register(EVAL_READPURITY);
            registry.register(EVAL_READSTRENGTH);
            registry.register(EVAL_READEFFICIENCY);
            registry.register(EVAL_READQUALITY);
            registry.register(EVAL_READPOWER);
            registry.register(EVAL_READLASER);
            return null;
        }
    }
}

