/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.blocks.laser;

import java.awt.Rectangle;
import java.text.DecimalFormat;
import mcjty.deepresonance.DeepResonance;
import mcjty.deepresonance.blocks.laser.InfusingBonus;
import mcjty.deepresonance.blocks.laser.LaserContainer;
import mcjty.deepresonance.blocks.laser.LaserTileEntity;
import mcjty.deepresonance.config.ConfigMachines;
import mcjty.deepresonance.network.DRMessages;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;

public class GuiLaser
extends GenericGuiContainer<LaserTileEntity> {
    public static final int LASER_WIDTH = 180;
    public static final int LASER_HEIGHT = 152;
    private EnergyBar energyBar;
    private EnergyBar crystalBar;
    private Label purifyBonus;
    private Label strengthBonus;
    private Label efficiencyBonus;
    private static final ResourceLocation iconLocation = new ResourceLocation("deepresonance", "textures/gui/laser.png");

    public GuiLaser(LaserTileEntity laserTileEntity, LaserContainer container) {
        super((ModBase)DeepResonance.instance, DRMessages.INSTANCE, (GenericTileEntity)laserTileEntity, (Container)container, 0, "laser");
        LaserTileEntity.setCurrentRF((long)laserTileEntity.getStoredPower());
        this.field_146999_f = 180;
        this.field_147000_g = 152;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        long maxEnergyStored = ((LaserTileEntity)this.tileEntity).getCapacity();
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 8, 59))).setShowText(false);
        LaserTileEntity cfr_ignored_0 = (LaserTileEntity)this.tileEntity;
        this.energyBar.setValue(LaserTileEntity.getCurrentRF());
        this.crystalBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue((long)ConfigMachines.laser.crystalLiquidMaximum).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(153, 7, 19, 38))).setShowText(false);
        this.crystalBar.setEnergyOnColor(-16750849);
        this.crystalBar.setEnergyOffColor(-16764058);
        this.crystalBar.setSpacerColor(-16772830);
        this.crystalBar.setValue(0L);
        this.purifyBonus = (Label)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.purifyBonus.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 5, 100, 14));
        this.strengthBonus = (Label)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.strengthBonus.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 23, 100, 14));
        this.efficiencyBonus = (Label)new Label(this.field_146297_k, (Gui)this).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.efficiencyBonus.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 41, 100, 14));
        Panel catalystPanel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(41, 7, 109, 59))).setFilledRectThickness(-2)).setFilledBackground(StyleConfig.colorListBackground)).addChild((Widget)this.purifyBonus)).addChild((Widget)this.strengthBonus)).addChild((Widget)this.efficiencyBonus);
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)catalystPanel)).addChild((Widget)this.crystalBar);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        ((LaserTileEntity)this.tileEntity).requestRfFromServer("deepresonance");
        ((LaserTileEntity)this.tileEntity).requestCrystalLiquidFromServer();
    }

    protected void func_146976_a(float v, int i, int i2) {
        Slot slot = this.field_147002_h.func_75139_a(1);
        if (slot.func_75216_d()) {
            InfusingBonus bonus = LaserTileEntity.getInfusingBonus(slot.func_75211_c());
            if (bonus != null) {
                this.setBonusText(bonus.getPurityModifier(), "P", this.purifyBonus);
                this.setBonusText(bonus.getStrengthModifier(), "S", this.strengthBonus);
                this.setBonusText(bonus.getEfficiencyModifier(), "E", this.efficiencyBonus);
            } else {
                this.purifyBonus.setText("Not a catalyst!");
                this.strengthBonus.setText("");
                this.efficiencyBonus.setText("");
            }
        } else {
            this.purifyBonus.setText("Catalyst missing!");
            this.strengthBonus.setText("");
            this.efficiencyBonus.setText("");
        }
        this.drawWindow();
        LaserTileEntity cfr_ignored_0 = (LaserTileEntity)this.tileEntity;
        this.energyBar.setValue(LaserTileEntity.getCurrentRF());
        this.crystalBar.setValue((long)LaserTileEntity.getCrystalLiquidClient());
        ((LaserTileEntity)this.tileEntity).requestRfFromServer("deepresonance");
        ((LaserTileEntity)this.tileEntity).requestCrystalLiquidFromServer();
    }

    private void setBonusText(InfusingBonus.Modifier modifier, String prefix, Label label) {
        if (Math.abs(modifier.getBonus()) > 0.01f) {
            label.setText(prefix + ": " + this.formatted(modifier.getBonus()) + "% (cap " + this.formatted(modifier.getMaxOrMin()) + ")");
        } else {
            label.setText(prefix + ": none");
        }
    }

    private String formatted(float f) {
        return new DecimalFormat("##.#").format(f);
    }
}

