/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.network.message;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.blay09.mods.cookingforblockheads.api.FoodRecipeWithStatus;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageItemList
implements IMessage {
    private Collection<FoodRecipeWithStatus> recipeList;
    private boolean hasOven;

    public MessageItemList() {
    }

    public MessageItemList(Collection<FoodRecipeWithStatus> recipeList, boolean hasOven) {
        this.recipeList = recipeList;
        this.hasOven = hasOven;
    }

    public void fromBytes(ByteBuf buf) {
        int recipeCount = buf.readInt();
        this.recipeList = Lists.newArrayListWithCapacity((int)recipeCount);
        for (int i = 0; i < recipeCount; ++i) {
            this.recipeList.add(this.readRecipe(buf));
        }
        this.hasOven = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        int recipeCount = this.recipeList.size();
        buf.writeInt(recipeCount);
        for (FoodRecipeWithStatus recipe : this.recipeList) {
            this.writeRecipe(recipe, buf);
        }
        buf.writeBoolean(this.hasOven);
    }

    public Collection<FoodRecipeWithStatus> getRecipeList() {
        return this.recipeList;
    }

    public boolean getHasOven() {
        return this.hasOven;
    }

    private FoodRecipeWithStatus readRecipe(ByteBuf buf) {
        ItemStack outputItem = ByteBufUtils.readItemStack((ByteBuf)buf);
        RecipeStatus status = RecipeStatus.fromId(buf.readByte());
        return new FoodRecipeWithStatus(outputItem, status);
    }

    private void writeRecipe(FoodRecipeWithStatus recipe, ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)recipe.getOutputItem());
        buf.writeByte(recipe.getStatus().ordinal());
    }
}

