/*
 * Decompiled with CFR 0.152.
 */
package vazkii.arl.block;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.block.BlockMetaVariants;
import vazkii.arl.block.BlockMod;
import vazkii.arl.interf.IBlockColorProvider;

public abstract class BlockModDust
extends BlockMod
implements IBlockColorProvider {
    public static final PropertyEnum<EnumAttachPosition> NORTH = PropertyEnum.func_177709_a((String)"north", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> EAST = PropertyEnum.func_177709_a((String)"east", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> SOUTH = PropertyEnum.func_177709_a((String)"south", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> WEST = PropertyEnum.func_177709_a((String)"west", EnumAttachPosition.class);
    protected static final AxisAlignedBB[] WIRE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0)};

    public BlockModDust(String name) {
        super(name, Material.field_151594_q, new String[0]);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(NORTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(EAST, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(SOUTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(WEST, (Comparable)((Object)EnumAttachPosition.NONE)));
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return WIRE_AABB[BlockModDust.getAABBIndex(state.func_185899_b(source, pos))];
    }

    private static int getAABBIndex(IBlockState state) {
        boolean west;
        int i = 0;
        boolean north = state.func_177229_b(NORTH) != EnumAttachPosition.NONE;
        boolean east = state.func_177229_b(EAST) != EnumAttachPosition.NONE;
        boolean south = state.func_177229_b(SOUTH) != EnumAttachPosition.NONE;
        boolean bl = west = state.func_177229_b(WEST) != EnumAttachPosition.NONE;
        if (north || south && !east && !west) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (east || west && !north && !south) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (south || north && !east && !west) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (west || east && !north && !south) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = state.func_177226_a(WEST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.WEST)));
        state = state.func_177226_a(EAST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.EAST)));
        state = state.func_177226_a(NORTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.NORTH)));
        state = state.func_177226_a(SOUTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.SOUTH)));
        return state;
    }

    protected EnumAttachPosition getAttachPosition(IBlockAccess worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (!(this.canConnectTo(worldIn.func_180495_p(blockpos), direction, worldIn, blockpos) || !iblockstate.func_185915_l() && this.canConnectUpwardsTo(worldIn, blockpos.func_177977_b()))) {
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177984_a());
            if (!iblockstate1.func_185915_l()) {
                boolean flag;
                boolean bl = flag = worldIn.func_180495_p(blockpos).isSideSolid(worldIn, blockpos, EnumFacing.UP) || worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150426_aN;
                if (flag && this.canConnectUpwardsTo(worldIn, blockpos.func_177984_a())) {
                    if (iblockstate.func_185898_k()) {
                        return EnumAttachPosition.UP;
                    }
                    return EnumAttachPosition.SIDE;
                }
            }
            return EnumAttachPosition.NONE;
        }
        return EnumAttachPosition.SIDE;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, @Nonnull IBlockAccess worldIn, @Nonnull BlockPos pos) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150426_aN;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K && !this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    protected boolean canConnectUpwardsTo(IBlockAccess worldIn, BlockPos pos) {
        return this.canConnectTo(worldIn.func_180495_p(pos), null, worldIn, pos);
    }

    protected boolean canConnectTo(IBlockState blockState, @Nullable EnumFacing side, IBlockAccess world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        return block == this;
    }

    @Nonnull
    public ItemStack func_185473_a(World worldIn, BlockPos pos, @Nonnull IBlockState state) {
        return new ItemStack(this.func_180660_a(state, worldIn.field_73012_v, 0));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(EAST, state.func_177229_b(WEST)).func_177226_a(SOUTH, state.func_177229_b(NORTH)).func_177226_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a(NORTH, state.func_177229_b(EAST)).func_177226_a(EAST, state.func_177229_b(SOUTH)).func_177226_a(SOUTH, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a(NORTH, state.func_177229_b(WEST)).func_177226_a(EAST, state.func_177229_b(NORTH)).func_177226_a(SOUTH, state.func_177229_b(EAST)).func_177226_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a(EAST, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST});
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public abstract int getColor(IBlockAccess var1, IBlockState var2, BlockPos var3, int var4);

    @Override
    public IBlockColor getBlockColor() {
        return (state, world, pos, tint) -> this.getColor(world, state, pos, tint);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return (stack, tint) -> 0xFFFFFF;
    }

    protected static enum EnumAttachPosition implements BlockMetaVariants.EnumBase
    {
        UP,
        SIDE,
        NONE;

    }
}

