/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig.factory;

import info.loenwind.autoconfig.factory.AbstractValue;
import info.loenwind.autoconfig.factory.ByteBufAdapters;
import info.loenwind.autoconfig.factory.IByteBufAdapter;
import info.loenwind.autoconfig.factory.IValueFactory;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Property;

class DoubleValue
extends AbstractValue<Double> {
    protected DoubleValue(IValueFactory owner, String section, String keyname, Double defaultValue, String text) {
        super(owner, section, keyname, defaultValue, text);
    }

    @Override
    @Nullable
    protected Double makeValue() {
        String comment = this.getText() + " [range: " + (this.minValue != null ? this.minValue : Double.NEGATIVE_INFINITY) + " ~ " + (this.maxValue != null ? this.maxValue : Double.MAX_VALUE) + ", default: " + this.defaultValue + "]";
        Property property = this.owner.getConfig().get(this.section, this.keyname, ((Double)this.defaultValue).doubleValue(), comment);
        if (this.minValue != null) {
            property.setMinValue(this.minValue.doubleValue());
        }
        if (this.maxValue != null) {
            property.setMaxValue(this.maxValue.doubleValue());
        }
        property.setRequiresMcRestart(this.isStartup);
        return property.getDouble(((Double)this.defaultValue).doubleValue());
    }

    @Override
    protected IByteBufAdapter<Double> getDataType() {
        return ByteBufAdapters.DOUBLE;
    }
}

