/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.forge;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import reborncore.api.power.ExternalPowerHandler;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.powerSystem.forge.ForgeEnergyStorage;
import reborncore.common.powerSystem.forge.ForgePowerManager;

public class ForgePowerHandler
implements ExternalPowerHandler {
    TilePowerAcceptor powerAcceptor;
    ForgeEnergyStorage powerManager;

    public ForgePowerHandler(TilePowerAcceptor powerAcceptor) {
        this.powerAcceptor = powerAcceptor;
        this.powerManager = new ForgeEnergyStorage(powerAcceptor, null);
    }

    @Override
    public void tick() {
        HashMap<EnumFacing, TileEntity> acceptors = new HashMap<EnumFacing, TileEntity>();
        if (this.powerAcceptor.getEnergy() > 0.0) {
            for (EnumFacing side : EnumFacing.values()) {
                TileEntity tile;
                if (!this.powerAcceptor.canProvideEnergy(side) || (tile = this.powerAcceptor.func_145831_w().func_175625_s(this.powerAcceptor.func_174877_v().func_177972_a(side))) == null || ForgePowerHandler.isOtherPoweredTile(tile, side.func_176734_d())) continue;
                if (tile instanceof IEnergyInterfaceTile) {
                    IEnergyInterfaceTile eFace = (IEnergyInterfaceTile)tile;
                    if (!eFace.canAcceptEnergy(side.func_176734_d())) continue;
                    acceptors.put(side, tile);
                    continue;
                }
                if (!tile.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) continue;
                acceptors.put(side, tile);
            }
        }
        if (acceptors.size() > 0) {
            double drain = this.powerAcceptor.useEnergy(Math.min(this.powerAcceptor.getEnergy(), this.powerAcceptor.getMaxOutput()), true);
            double energyShare = drain / (double)acceptors.size();
            double remainingEnergy = drain;
            if (energyShare > 0.0) {
                for (Map.Entry entry : acceptors.entrySet()) {
                    EnumFacing side = (EnumFacing)entry.getKey();
                    TileEntity tile = (TileEntity)entry.getValue();
                    if (tile instanceof IEnergyInterfaceTile) {
                        IEnergyInterfaceTile eFace = (IEnergyInterfaceTile)tile;
                        if (RebornCoreConfig.smokeHighTeir && this.powerAcceptor.handleTierWithPower() && eFace.getTier().ordinal() < this.powerAcceptor.getPushingTier().ordinal()) {
                            World world = this.powerAcceptor.func_145831_w();
                            BlockPos pos = this.powerAcceptor.func_174877_v();
                            for (int j = 0; j < 2; ++j) {
                                double d3 = (double)pos.func_177958_n() + world.field_73012_v.nextDouble() + (double)(side.func_82601_c() / 2);
                                double d8 = (double)pos.func_177956_o() + world.field_73012_v.nextDouble() + 1.0;
                                double d13 = (double)pos.func_177952_p() + world.field_73012_v.nextDouble() + (double)(side.func_82599_e() / 2);
                                ((WorldServer)world).func_180505_a(EnumParticleTypes.SMOKE_LARGE, false, d3, d8, d13, 2, 0.0, 0.0, 0.0, 0.0, new int[0]);
                            }
                            continue;
                        }
                        double filled = eFace.addEnergy(Math.min(energyShare, remainingEnergy), false);
                        remainingEnergy -= this.powerAcceptor.useEnergy(filled, false);
                        continue;
                    }
                    if (!tile.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) continue;
                    IEnergyStorage energyStorage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d());
                    if (this.powerManager == null || energyStorage == null || !energyStorage.canReceive() || !this.powerAcceptor.canProvideEnergy(side)) continue;
                    int filled = energyStorage.receiveEnergy((int)Math.min(energyShare, remainingEnergy) * RebornCoreConfig.euPerFU, false);
                    remainingEnergy -= this.powerAcceptor.useEnergy(filled / RebornCoreConfig.euPerFU, false);
                }
            }
        }
    }

    @Override
    public void unload() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY && (this.powerAcceptor.canAcceptEnergy(facing) || this.powerAcceptor.canProvideEnergy(facing));
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && (this.powerAcceptor.canAcceptEnergy(facing) || this.powerAcceptor.canProvideEnergy(facing))) {
            if (this.powerManager == null) {
                this.powerManager = new ForgeEnergyStorage(this.powerAcceptor, facing);
            }
            this.powerManager.setFacing(facing);
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.powerManager);
        }
        return null;
    }

    private static boolean isOtherPoweredTile(TileEntity tileEntity, EnumFacing facing) {
        return ExternalPowerSystems.externalPowerHandlerList.stream().filter(externalPowerManager -> !(externalPowerManager instanceof ForgePowerManager)).anyMatch(externalPowerManager -> externalPowerManager.isPoweredTile(tileEntity, facing));
    }
}

