/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.CRC32;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import reborncore.RebornCore;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.PacketWrapper;
import reborncore.common.network.RegisterPacketEvent;

public class NetworkManager {
    public static HashMap<Class<? extends INetworkPacket>, SimpleNetworkWrapper> packetWrapperMap = new HashMap();
    public static HashMap<String, SimpleNetworkWrapper> packageWrapperMap = new HashMap();
    private static HashMap<SimpleNetworkWrapper, IntStore> wrapperIdList = new HashMap();
    public static ArrayList<PacketDetails> packetList = new ArrayList();

    public static void load() {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterPacketEvent());
    }

    public static void sendToServer(INetworkPacket packet) {
        NetworkManager.checkPacket(packet);
        NetworkManager.getWrapperForPacket(packet.getClass()).sendToServer((IMessage)new PacketWrapper(packet));
    }

    public static void sendToAllAround(INetworkPacket packet, NetworkRegistry.TargetPoint point) {
        NetworkManager.checkPacket(packet);
        NetworkManager.getWrapperForPacket(packet.getClass()).sendToAllAround((IMessage)new PacketWrapper(packet), point);
    }

    public static void sendToAll(INetworkPacket packet) {
        NetworkManager.checkPacket(packet);
        NetworkManager.getWrapperForPacket(packet.getClass()).sendToAll((IMessage)new PacketWrapper(packet));
    }

    public static void sendToPlayer(INetworkPacket packet, EntityPlayerMP playerMP) {
        NetworkManager.checkPacket(packet);
        NetworkManager.getWrapperForPacket(packet.getClass()).sendTo((IMessage)new PacketWrapper(packet), playerMP);
    }

    public static void sendToWorld(INetworkPacket packet, World world) {
        NetworkManager.checkPacket(packet);
        NetworkManager.getWrapperForPacket(packet.getClass()).sendToDimension((IMessage)new PacketWrapper(packet), world.field_73011_w.getDimension());
    }

    public static void checkPacket(INetworkPacket packet) {
        if (NetworkManager.getPacketDetails(packet.getClass()) == null) {
            throw new RuntimeException("Packet " + packet.getClass().getName() + " has not been registered");
        }
    }

    public static PacketDetails getPacketDetails(Class<? extends INetworkPacket> clazz) {
        return packetList.stream().filter(packetDetails -> packetDetails.packetClass.equals(clazz)).findAny().orElse(null);
    }

    public static SimpleNetworkWrapper getWrapperForPacket(Class<? extends INetworkPacket> packetClass) {
        if (!packetWrapperMap.containsKey(packetClass)) {
            return null;
        }
        return packetWrapperMap.get(packetClass);
    }

    public static SimpleNetworkWrapper createOrGetNetworkWrapper(Class<? extends INetworkPacket> packetClass) {
        String wrapperName = NetworkManager.getWrapperName(packetClass);
        if (packageWrapperMap.containsKey(wrapperName)) {
            return packageWrapperMap.get(wrapperName);
        }
        SimpleNetworkWrapper newNetworkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(wrapperName);
        RebornCore.logHelper.info("Created new network wrapper " + wrapperName);
        packageWrapperMap.put(wrapperName, newNetworkWrapper);
        return newNetworkWrapper;
    }

    public static String getWrapperName(Class<? extends INetworkPacket> packetClass) {
        String packageName = packetClass.getCanonicalName().substring(0, packetClass.getCanonicalName().lastIndexOf("."));
        CRC32 crc = new CRC32();
        crc.update(packageName.getBytes());
        return "rc&" + packageName.substring(0, 11) + "&" + Long.toString(crc.getValue()).substring(0, 5);
    }

    public static PacketDetails registerPacket(Class<? extends INetworkPacket> packetClass, Side side) {
        SimpleNetworkWrapper wrapper = NetworkManager.createOrGetNetworkWrapper(packetClass);
        int id = NetworkManager.getNextIDForWrapper(wrapper);
        wrapper.registerMessage(PacketWrapper.PacketWrapperHandler.class, PacketWrapper.class, id, side);
        packetWrapperMap.put(packetClass, wrapper);
        RebornCore.logHelper.info("Registed packet to " + NetworkManager.getWrapperName(packetClass) + " side: " + side + " id:" + id);
        PacketDetails packetDetails = new PacketDetails(packetClass, id, wrapper);
        packetList.add(packetDetails);
        return packetDetails;
    }

    public static int getNextIDForWrapper(SimpleNetworkWrapper networkWrapper) {
        if (wrapperIdList.containsKey(networkWrapper)) {
            ++NetworkManager.wrapperIdList.get((Object)networkWrapper).id;
            return NetworkManager.wrapperIdList.get((Object)networkWrapper).id;
        }
        wrapperIdList.put(networkWrapper, new IntStore());
        return 0;
    }

    public static class PacketDetails {
        public Class<? extends INetworkPacket> packetClass;
        public int id;
        SimpleNetworkWrapper networkWrapper;

        public PacketDetails(Class<? extends INetworkPacket> packetClass, int id, SimpleNetworkWrapper networkWrapper) {
            this.packetClass = packetClass;
            this.id = id;
            this.networkWrapper = networkWrapper;
        }
    }

    private static class IntStore {
        int id = 0;

        private IntStore() {
        }
    }
}

