/*
 * Decompiled with CFR 0.152.
 */
package reborncore.client.gui.builder.slot;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.slot.elements.ConfigFluidElement;
import reborncore.client.gui.builder.slot.elements.ElementBase;
import reborncore.client.gui.builder.slot.elements.SlotType;
import reborncore.common.tile.TileLegacyMachineBase;

public class GuiFluidConfiguration {
    static ConfigFluidElement fluidConfigElement;

    public static void init(GuiBase guiBase) {
        fluidConfigElement = new ConfigFluidElement(guiBase.getMachine().getTank(), SlotType.NORMAL, 35 - guiBase.field_147003_i + 50, 35 - guiBase.field_147009_r - 25, guiBase);
    }

    public static void draw(GuiBase guiBase, int mouseX, int mouseY) {
        fluidConfigElement.draw(guiBase);
    }

    @SubscribeEvent
    public static void keyboardEvent(GuiScreenEvent.KeyboardInputEvent event) {
        if (GuiBase.slotConfigType == GuiBase.SlotConfigType.FLUIDS && Keyboard.getEventKey() == 1) {
            GuiBase.slotConfigType = GuiBase.SlotConfigType.NONE;
            event.setCanceled(true);
        }
    }

    public static List<ConfigFluidElement> getVisibleElements() {
        return Collections.singletonList(fluidConfigElement);
    }

    public static boolean mouseClicked(int mouseX, int mouseY, int mouseButton, GuiBase guiBase) throws IOException {
        if (mouseButton == 0) {
            block0: for (ConfigFluidElement configFluidElement : GuiFluidConfiguration.getVisibleElements()) {
                for (ElementBase element : configFluidElement.elements) {
                    if (element.isInRect(guiBase, element.x, element.y, element.getWidth(guiBase.getMachine()), element.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                        element.isPressing = true;
                        boolean action = element.onStartPress(guiBase.getMachine(), guiBase, mouseX, mouseY);
                        for (ElementBase elementBase : GuiFluidConfiguration.getVisibleElements()) {
                            if (elementBase == element) continue;
                            elementBase.isPressing = false;
                        }
                        if (!action) continue;
                        continue block0;
                    }
                    element.isPressing = false;
                }
            }
        }
        return !GuiFluidConfiguration.getVisibleElements().isEmpty();
    }

    public static void mouseClickMove(int mouseX, int mouseY, int mouseButton, long timeSinceLastClick, GuiBase guiBase) {
        if (mouseButton == 0) {
            block0: for (ConfigFluidElement configFluidElement : GuiFluidConfiguration.getVisibleElements()) {
                for (ElementBase element : configFluidElement.elements) {
                    if (element.isInRect(guiBase, element.x, element.y, element.getWidth(guiBase.getMachine()), element.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                        element.isDragging = true;
                        boolean action = element.onDrag(guiBase.getMachine(), guiBase, mouseX, mouseY);
                        for (ElementBase elementBase : GuiFluidConfiguration.getVisibleElements()) {
                            if (elementBase == element) continue;
                            elementBase.isDragging = false;
                        }
                        if (!action) continue;
                        continue block0;
                    }
                    element.isDragging = false;
                }
            }
        }
    }

    public static boolean mouseReleased(int mouseX, int mouseY, int mouseButton, GuiBase guiBase) {
        boolean clicked = false;
        if (mouseButton == 0) {
            block0: for (ConfigFluidElement configFluidElement : GuiFluidConfiguration.getVisibleElements()) {
                if (configFluidElement.isInRect(guiBase, configFluidElement.x, configFluidElement.y, configFluidElement.getWidth(guiBase.getMachine()), configFluidElement.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                    clicked = true;
                }
                for (ElementBase element : Lists.reverse(configFluidElement.elements)) {
                    if (element.isInRect(guiBase, element.x, element.y, element.getWidth(guiBase.getMachine()), element.getHeight(guiBase.getMachine()), mouseX, mouseY)) {
                        element.isReleasing = true;
                        boolean action = element.onRelease(guiBase.getMachine(), guiBase, mouseX, mouseY);
                        for (ElementBase elementBase : GuiFluidConfiguration.getVisibleElements()) {
                            if (elementBase == element) continue;
                            elementBase.isReleasing = false;
                        }
                        if (!action) continue block0;
                        clicked = true;
                        continue block0;
                    }
                    element.isReleasing = false;
                }
            }
        }
        return clicked;
    }

    @Nullable
    private static TileLegacyMachineBase getMachine() {
        if (!(Minecraft.func_71410_x().field_71462_r instanceof GuiBase)) {
            return null;
        }
        GuiBase base = (GuiBase)Minecraft.func_71410_x().field_71462_r;
        if (!(base.tile instanceof TileLegacyMachineBase)) {
            return null;
        }
        TileLegacyMachineBase machineBase = (TileLegacyMachineBase)base.tile;
        return machineBase;
    }
}

