/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.items.tools.MiningToolBase;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import com.brandon3055.draconicevolution.utils.DETextures;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WyvernShovel
extends MiningToolBase {
    public WyvernShovel(Set<Block> effectiveBlocks) {
        super(effectiveBlocks);
    }

    public WyvernShovel() {
        super(SHOVEL_OVERRIDES);
        this.setHarvestLevel("shovel", 10);
    }

    @Override
    public double getBaseMinSpeedConfig() {
        return ToolStats.WYV_SHOVEL_MINING_SPEED;
    }

    @Override
    public int getBaseMinAOEConfig() {
        return ToolStats.BASE_WYVERN_MINING_AOE;
    }

    @Override
    public double getBaseAttackSpeedConfig() {
        return ToolStats.WYV_SHOVEL_ATTACK_SPEED;
    }

    @Override
    public double getBaseAttackDamageConfig() {
        return ToolStats.WYV_SHOVEL_ATTACK_DAMAGE;
    }

    @Override
    public void loadEnergyStats() {
        this.setEnergyStats(ToolStats.WYVERN_BASE_CAPACITY, 512000, 0);
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 2;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 0;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.flattenBlock(stack, player, world, pos, facing)) {
            if (world.func_180495_p(pos).func_177230_c() != Blocks.field_185774_da) {
                return EnumActionResult.FAIL;
            }
        } else {
            this.modifyEnergy(stack, -this.energyPerOperation);
        }
        if (player.func_70093_af()) {
            return EnumActionResult.SUCCESS;
        }
        int AOE = ToolConfigHelper.getIntegerField("digAOE", stack);
        Iterable blocks = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-AOE, 0, -AOE), (BlockPos)pos.func_177982_a(AOE, 0, AOE));
        for (BlockPos aoePos : blocks) {
            if (aoePos.equals((Object)pos)) continue;
            boolean replaceable = world.func_180495_p(aoePos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, aoePos.func_177984_a());
            if (world.func_175623_d(aoePos) || !replaceable || !this.flattenBlock(stack, player, world, aoePos, facing)) continue;
            this.modifyEnergy(stack, -this.energyPerOperation);
        }
        return EnumActionResult.SUCCESS;
    }

    private boolean flattenBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing face) {
        if (this.getEnergyStored(stack) < this.energyPerOperation && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (!player.func_175151_a(pos, face, stack)) {
            return false;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (face != EnumFacing.DOWN && block == Blocks.field_150349_c) {
            world.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                if (!world.func_175623_d(pos.func_177984_a())) {
                    world.func_175698_g(pos.func_177984_a());
                }
                this.setBlock(player, world, pos, Blocks.field_185774_da.func_176223_P());
            }
            return true;
        }
        return false;
    }

    protected void setBlock(EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
        }
    }

    @Override
    public PairKV<TextureAtlasSprite, ResourceLocation> getModels(ItemStack stack) {
        return new PairKV((Object)DETextures.WYVERN_SHOVEL, (Object)new ResourceLocation("draconicevolution", "models/item/tools/wyvern_shovel.obj"));
    }
}

