/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.effect;

import codechicken.lib.render.CCModelLibrary;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.RenderEnergyBolt;
import java.util.Random;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class EffectTrackerCelestialManipulator {
    public static double interpPosX = 0.0;
    public static double interpPosY = 0.0;
    public static double interpPosZ = 0.0;
    private Random rand = new Random();
    public Vec3D effectFocus;
    public Vec3D linkPos = null;
    private int renderBolt = 0;
    private float rotation;
    private float rotationSpeed = 2.0f;
    private float aRandomFloat = 0.0f;
    public boolean positionLocked = false;
    public Vec3D startPos;
    public Vec3D pos;
    public Vec3D prevPos = new Vec3D();
    public Vec3D circlePosition = new Vec3D();
    private World world;
    private long boltSeed = 0L;
    public boolean renderBolts = true;
    public float alpha = 0.0f;
    public float scale = 1.0f;
    public float red = 0.0f;
    public float green = 1.0f;
    public float blue = 1.0f;

    public EffectTrackerCelestialManipulator(World world, Vec3D pos, Vec3D effectFocus) {
        this.world = world;
        this.effectFocus = effectFocus;
        this.rotation = this.rand.nextInt(1000);
        this.aRandomFloat = this.rand.nextFloat();
        this.pos = pos.copy();
        this.startPos = pos.copy();
        this.prevPos.set(pos);
        this.red = 0.1f;
        this.green = 0.1f;
        this.alpha = 1.0f;
    }

    public void onUpdate() {
        this.prevPos.set(this.pos);
        if (this.renderBolt > 0) {
            --this.renderBolt;
        }
        this.renderBolt = 1;
        this.boltSeed = this.rand.nextLong();
        BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)new SubParticle(this.world, this.effectFocus), (double)128.0, (boolean)true);
        this.rotationSpeed = -1.0f;
        this.rotation += this.rotationSpeed;
    }

    public void renderEffect(Tessellator tessellator, float partialTicks) {
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        CCRenderState ccrs = CCRenderState.instance();
        float relativeX = (float)(this.prevPos.x + (this.pos.x - this.prevPos.x) * (double)partialTicks - interpPosX);
        float relativeY = (float)(this.prevPos.y + (this.pos.y - this.prevPos.y) * (double)partialTicks - interpPosY);
        float relativeZ = (float)(this.prevPos.z + (this.pos.z - this.prevPos.z) * (double)partialTicks - interpPosZ);
        float correctX = (float)(this.prevPos.x + (this.pos.x - this.prevPos.x) * (double)partialTicks);
        float correctY = (float)(this.prevPos.y + (this.pos.y - this.prevPos.y) * (double)partialTicks);
        float correctZ = (float)(this.prevPos.z + (this.pos.z - this.prevPos.z) * (double)partialTicks);
        GlStateManager.func_179094_E();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)200.0f);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
        GlStateManager.func_179109_b((float)relativeX, (float)relativeY, (float)relativeZ);
        GlStateManager.func_179114_b((float)(this.rotation + partialTicks * this.rotationSpeed), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(-relativeX), (float)(-relativeY), (float)(-relativeZ));
        ccrs.reset();
        ccrs.startDrawing(7, DefaultVertexFormats.field_181710_j, vertexbuffer);
        Matrix4 pearlMat = RenderUtils.getMatrix((Vector3)new Vector3((double)relativeX, (double)relativeY, (double)relativeZ), (Rotation)new Rotation(0.0, new Vector3(0.0, 0.0, 0.0)), (double)(0.15 * (double)this.scale));
        ccrs.bind(vertexbuffer);
        CCModelLibrary.icosahedron7.render(ccrs, new IVertexOperation[]{pearlMat});
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)relativeX, (float)relativeY, (float)relativeZ);
        int segments = Math.max(4, (int)(8.0f * this.scale));
        if (this.renderBolt > 0 && this.scale > 0.0f && this.renderBolts) {
            RenderEnergyBolt.renderBoltBetween(new Vec3D(), this.effectFocus.copy().subtract((double)correctX, (double)correctY, (double)correctZ), 0.05 * (double)this.scale, (double)this.scale * 0.5, segments, this.boltSeed, false);
        }
        if (this.linkPos != null && this.scale > 0.0f) {
            RenderEnergyBolt.renderBoltBetween(new Vec3D(), this.linkPos.copy().subtract((double)correctX, (double)correctY, (double)correctZ), 0.05 * (double)this.scale, (double)this.scale * 0.5, segments, this.boltSeed, false);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
    }

    public static class SubParticle2
    extends BCParticle {
        private final EffectTrackerCelestialManipulator target;
        public boolean targetMode = false;

        public SubParticle2(World worldIn, Vec3D pos, EffectTrackerCelestialManipulator target) {
            super(worldIn, pos);
            this.target = target;
            double speed = 1.0;
            this.field_187129_i = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187130_j = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187131_k = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_70547_e = 150 + this.field_187136_p.nextInt(10);
            this.field_70544_f = 1.0f;
            this.field_94055_c = 1;
            this.field_70552_h = 0.0f;
        }

        public BCParticle setScale(float scale) {
            super.setScale(scale);
            double speed = 1.0;
            this.field_187129_i = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187130_j = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187131_k = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            return this;
        }

        public boolean func_187111_c() {
            return true;
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            Vec3D thisPos = new Vec3D(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            Vec3D dir = Vec3D.getDirectionVec((Vec3D)thisPos, (Vec3D)this.target.pos);
            double distance = Utils.getDistanceAtoB((Vec3D)thisPos, (Vec3D)this.target.pos) * 0.8;
            double speed = 0.01 * distance;
            if (distance > 2.0 && this.field_187136_p.nextInt(90) == 0) {
                this.targetMode = true;
            }
            double dragModifier = 0.95 / distance;
            this.field_187129_i *= dragModifier;
            this.field_187130_j *= dragModifier;
            this.field_187131_k *= dragModifier;
            this.field_187129_i += dir.x * speed;
            this.field_187130_j += dir.y * speed;
            this.field_187131_k += dir.z * speed;
            if (this.targetMode) {
                this.field_187129_i = dir.x * 0.1;
                this.field_187130_j = dir.y * 0.1;
                this.field_187131_k = dir.z * 0.1;
            }
            this.field_94054_b = this.field_187136_p.nextInt(5);
            int ttd = this.field_70547_e - this.field_70546_d;
            if (ttd < 10) {
                this.field_70544_f = (float)ttd / 10.0f;
            }
            this.moveEntityNoClip(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            if (distance < 0.5) {
                this.field_70546_d += 4;
            }
            if (this.field_70546_d++ > this.field_70547_e) {
                this.func_187112_i();
            }
        }

        public void func_180434_a(BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            if (this.field_70546_d == 0) {
                return;
            }
            float minU = (float)this.field_94054_b / 8.0f;
            float maxU = minU + 0.125f;
            float minV = (float)this.field_94055_c / 8.0f;
            float maxV = minV + 0.125f;
            float scale = 0.1f * this.field_70544_f;
            float renderX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float renderY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float renderZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            int brightnessForRender = this.func_189214_a(partialTicks);
            int j = brightnessForRender >> 16 & 0xFFFF;
            int k = brightnessForRender & 0xFFFF;
            vertexbuffer.func_181662_b((double)(renderX - rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ - rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX - rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ - rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX + rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ + rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX + rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ + rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        }
    }

    public static class SubParticle
    extends BCParticle {
        public SubParticle(World worldIn, Vec3D pos) {
            super(worldIn, pos);
            double speed = 0.1;
            this.field_187129_i = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187130_j = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187131_k = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_70547_e = 10 + this.field_187136_p.nextInt(10);
            this.field_70544_f = 1.0f;
            this.field_94055_c = 1;
            this.field_70552_h = 0.0f;
        }

        public BCParticle setScale(float scale) {
            super.setScale(scale);
            double speed = 0.1 * (double)scale;
            this.field_187129_i = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187130_j = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            this.field_187131_k = (-0.5 + this.field_187136_p.nextDouble()) * speed;
            return this;
        }

        public boolean func_187111_c() {
            return true;
        }

        public void func_189213_a() {
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            this.field_94054_b = this.field_187136_p.nextInt(5);
            int ttd = this.field_70547_e - this.field_70546_d;
            if (ttd < 10) {
                this.field_70544_f = (float)ttd / 10.0f;
            }
            this.moveEntityNoClip(this.field_187129_i, this.field_187130_j, this.field_187131_k);
            if (this.field_70546_d++ > this.field_70547_e) {
                this.func_187112_i();
            }
        }

        public void func_180434_a(BufferBuilder vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            if (this.field_70546_d == 0) {
                return;
            }
            float minU = (float)this.field_94054_b / 8.0f;
            float maxU = minU + 0.125f;
            float minV = (float)this.field_94055_c / 8.0f;
            float maxV = minV + 0.125f;
            float scale = 0.1f * this.field_70544_f;
            float renderX = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
            float renderY = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
            float renderZ = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
            int brightnessForRender = this.func_189214_a(partialTicks);
            int j = brightnessForRender >> 16 & 0xFFFF;
            int k = brightnessForRender & 0xFFFF;
            vertexbuffer.func_181662_b((double)(renderX - rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ - rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX - rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ - rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX + rotationX * scale + rotationXY * scale), (double)(renderY + rotationZ * scale), (double)(renderZ + rotationYZ * scale + rotationXZ * scale)).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            vertexbuffer.func_181662_b((double)(renderX + rotationX * scale - rotationXY * scale), (double)(renderY - rotationZ * scale), (double)(renderZ + rotationYZ * scale - rotationXZ * scale)).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
        }
    }
}

