/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.brandon3055.brandonscore.blocks.TileEnergyInventoryBase;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.blocks.machines.Grinder;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class TileGrinder
extends TileEnergyInventoryBase
implements IEnergyReceiver,
ITickable {
    public final ManagedBool active = (ManagedBool)this.register("active", (IManagedData)new ManagedBool(false)).syncViaTile().saveToTile().trigerUpdate().finish();
    public static FakePlayer fakePlayer;
    private AxisAlignedBB killBox;
    public boolean powered = false;
    private int coolDown = 0;
    private static GrinderPredicate grinderPredicate;

    public TileGrinder() {
        this.setInventorySize(1);
        this.setEnergySyncMode().syncViaContainer();
        this.setCapacityAndTransfer(500000, 32000, 0);
        this.setShouldRefreshOnBlockChange();
    }

    public void func_73660_a() {
        super.update();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = this.active.value = this.getEnergyStored() > 0 && !this.powered;
        if (this.active.value) {
            this.updateGrinding();
        }
        if (this.getEnergyStored() < this.getMaxEnergyStored() && this.func_70301_a(0) != null) {
            this.energyStorage.receiveEnergy(this.extractEnergyFromItem(this.func_70301_a(0), this.energyStorage.receiveEnergy(32000, true), false), false);
        }
    }

    private void updateGrinding() {
        if (fakePlayer == null) {
            fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(UUID.fromString("5b5689b9-e43d-4282-a42a-dc916f3616b7"), "[Draconic-Evolution]"));
        }
        if (this.killBox == null) {
            this.updateKillBox();
        }
        int eph = DEConfig.grinderEnergyPerHeart;
        if (this.getEnergyStored() < eph * 50) {
            return;
        }
        if (this.coolDown > 0) {
            --this.coolDown;
            return;
        }
        EntityLivingBase target = this.findTarget();
        if (target == null) {
            this.coolDown = 100;
            return;
        }
        float health = target.func_110143_aJ();
        if (health < 5.0f) {
            health = 5.0f;
        }
        int cost = (int)(health * (float)eph);
        boolean isConfirmedKill = false;
        if (cost > this.getEnergyStored()) {
            cost = this.getEnergyStored();
        } else {
            isConfirmedKill = true;
        }
        float damage = (float)cost / (float)eph * 1.1f;
        DamageSource source = DamageSource.func_76365_a((EntityPlayer)fakePlayer);
        if (isConfirmedKill) {
            damage = Float.MAX_VALUE;
        }
        if (target.func_70097_a(source, damage)) {
            LogHelper.dev("Grinder: Dealt " + damage + " damage to entity: " + target);
            this.energyStorage.modifyEnergyStored(-cost);
            this.coolDown = 2;
        } else {
            LogHelper.dev("Grinder: Failed to deal damage to entity: " + EntityList.func_75621_b((Entity)target) + " Waiting 3 ticks...");
            LogHelper.dev("Grinder: Blacklisted Entities: " + DEConfig.grinderBlacklist);
            this.coolDown = 3;
        }
        if (this.coolDown == 2) {
            List xp = this.field_145850_b.func_72872_a(EntityXPOrb.class, this.killBox.func_72314_b(4.0, 4.0, 4.0));
            for (EntityXPOrb orb : xp) {
                if (orb.field_70531_b >= 5400) continue;
                orb.field_70531_b = 5700;
            }
        }
    }

    private EntityLivingBase findTarget() {
        if (this.killBox == null) {
            return null;
        }
        List entitiesInRange = this.field_145850_b.func_175647_a(EntityLivingBase.class, this.killBox, (Predicate)grinderPredicate);
        EntityLivingBase found = null;
        for (EntityLivingBase livingBase : entitiesInRange) {
            if (!livingBase.func_70089_S() || this.isBlackListed(livingBase)) continue;
            found = livingBase;
            LogHelper.dev("Grinder: Found next target: " + livingBase);
            if (found.func_190530_aW()) {
                LogHelper.dev("Grinder: Target is invulnerable! searching for softer target...");
                continue;
            }
            return found;
        }
        return found;
    }

    private boolean isBlackListed(EntityLivingBase livingBase) {
        if (DEConfig.grinderBlacklist.isEmpty()) {
            return false;
        }
        ResourceLocation reg = EntityList.func_191301_a((Entity)livingBase);
        return reg != null && DEConfig.grinderBlacklist.contains(reg.toString());
    }

    public void updateKillBox() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Grinder.FACING);
        LogHelper.dev("Update Kill Box: " + facing);
        BlockPos pos1 = this.field_174879_c.func_177982_a(-3, -3, -3);
        BlockPos pos2 = this.field_174879_c.func_177982_a(4, 4, 4);
        pos1 = pos1.func_177982_a(facing.func_82601_c() * 4, 0, facing.func_82599_e() * 4);
        pos2 = pos2.func_177982_a(facing.func_82601_c() * 4, 0, facing.func_82599_e() * 4);
        this.killBox = new AxisAlignedBB(pos1, pos2);
    }

    public AxisAlignedBB getKillBoxForRender() {
        if (this.killBox == null) {
            this.updateKillBox();
        }
        return this.killBox;
    }

    public void updateBlock() {
        super.updateBlock();
        this.updateKillBox();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return super.receiveEnergy(from, maxReceive, simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return super.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return super.getMaxEnergyStored();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof IEnergyContainerItem;
    }

    static {
        grinderPredicate = new GrinderPredicate();
    }

    private static class GrinderPredicate
    implements Predicate<EntityLivingBase> {
        private GrinderPredicate() {
        }

        public boolean apply(EntityLivingBase input) {
            return !(input instanceof EntityPlayer) && input.func_70089_S();
        }
    }
}

