/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemconfig;

import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DoubleConfigField
implements IItemConfigField {
    protected final String name;
    protected String description;
    private IItemConfigField.EnumControlType controlType;
    protected double minValue;
    protected double maxValue;
    protected double value;
    private String extension = "";
    private String prefix = "";

    public DoubleConfigField(String name, double defaultValue, double minValue, double maxValue, String description, IItemConfigField.EnumControlType controlType) {
        this.name = name;
        this.value = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.description = description;
        this.controlType = controlType;
    }

    public DoubleConfigField setExtension(String extension) {
        this.extension = extension;
        return this;
    }

    public DoubleConfigField setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUnlocalizedName() {
        return "config.field." + this.getName() + ".entry";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getReadableValue() {
        return this.prefix + String.valueOf((double)Math.round(this.value * 100.0) / 100.0) + this.extension;
    }

    @Override
    public String getValueFraction(double percent) {
        return String.valueOf((double)Math.round(this.minValue + percent * (this.maxValue - this.minValue) * 100.0) / 100.0) + this.extension;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Double getMin() {
        return this.minValue;
    }

    @Override
    public Double getMax() {
        return this.maxValue;
    }

    @Override
    public Double getValue() {
        return this.value;
    }

    @Override
    public double getFractionalValue() {
        return (this.value - this.minValue) / (this.maxValue - this.minValue);
    }

    @Override
    public void handleButton(IItemConfigField.EnumButton button, int data) {
        switch (button) {
            case MINUS1: {
                this.value -= 0.01;
                break;
            }
            case MINUS2: {
                this.value -= 0.1;
                break;
            }
            case MINUS3: {
                this.value -= 1.0;
                break;
            }
            case PLUS1: {
                this.value += 0.01;
                break;
            }
            case PLUS2: {
                this.value += 0.1;
                break;
            }
            case PLUS3: {
                this.value += 1.0;
                break;
            }
            case MIN: {
                this.value = this.minValue;
                break;
            }
            case MAX: {
                this.value = this.maxValue;
                break;
            }
            case SLIDER: {
                double range = this.maxValue - this.minValue;
                double pos = (double)data / 10000.0 * range;
                this.value = this.minValue + pos;
            }
        }
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
        } else if (this.value < this.minValue) {
            this.value = this.minValue;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74780_a(this.name, this.value);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.value = compound.func_74769_h(this.name);
        if (this.value > this.maxValue) {
            this.value = this.maxValue;
            this.writeToNBT(compound);
        } else if (this.value < this.minValue) {
            this.value = this.minValue;
            this.writeToNBT(compound);
        }
    }

    @Override
    public IItemConfigField.EnumControlType getType() {
        return this.controlType;
    }

    @Override
    public Map<Integer, String> getValues() {
        return new HashMap<Integer, String>();
    }
}

