/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.render;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HUDProgress {
    public static final HUDProgress INSTANCE = new HUDProgress();
    private static final int FADE_IN_TIME = 20;
    private static final int FULL_TIME = 20;
    private static final float FADE_MULTIPLIER = 0.1f;
    private static final float GONE_TIME = 35.705f;
    private static final int DISPLAY = 64;
    private int progress;
    private float displayAngle;
    private int maxprogress;
    private int timeSinceLastUpdate = 10000;
    private float transparency;
    @Nonnull
    private final ResourceLocation location = new ResourceLocation("monk", "textures/circle.png");

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void clientTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (!Minecraft.func_71410_x().func_147113_T() && event.phase == TickEvent.Phase.START) {
            ++this.timeSinceLastUpdate;
            if (this.maxprogress >= 0) {
                float target = this.maxprogress == 0 ? 0.0f : (float)(this.progress < this.maxprogress ? (double)this.progress * Math.PI * 2.0 / (double)this.maxprogress : Math.PI * 2);
                float dt = target - this.displayAngle;
                this.displayAngle += Math.min(Math.abs(dt), 0.1f) * Math.signum(dt);
            } else {
                this.displayAngle = 0.0f;
                this.timeSinceLastUpdate = 50;
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void hudDraw(@Nonnull RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        if (this.maxprogress < 0) {
            return;
        }
        GuiIngameForge currentScreen = (GuiIngameForge)Minecraft.func_71410_x().field_71456_v;
        ScaledResolution resolution = event.getResolution();
        int size = resolution.func_78325_e() * 64 / 4;
        int cx = resolution.func_78326_a() - size;
        int cy = resolution.func_78328_b() - size;
        float partialTicks = event.getPartialTicks();
        float v = (float)this.timeSinceLastUpdate + partialTicks;
        if (v > 35.705f) {
            this.transparency = 0.0f;
            return;
        }
        float baseTransparency = v > 20.0f ? MathHelper.func_76134_b((float)((v - 20.0f) * 0.1f)) : (v < 20.0f && this.transparency < 1.0f ? this.transparency + 0.05f : 1.0f);
        this.transparency = baseTransparency;
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float target = (float)((double)this.progress * Math.PI * 2.0 / (double)this.maxprogress);
        float dt = target - this.displayAngle;
        float displayAngle2 = this.displayAngle + Math.min(Math.abs(dt), 0.1f) * Math.signum(dt);
        float partialAngle = this.displayAngle + (displayAngle2 - this.displayAngle) * partialTicks;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.location);
        Tessellator instance = Tessellator.func_178181_a();
        BufferBuilder buffer = instance.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.1f;
        if (target < this.displayAngle) {
            r = 1.0f;
        } else {
            g = 1.0f;
        }
        for (int i = 0; i < 180; ++i) {
            float angle1 = (float)i / 180.0f * 2.0f * 3.141592f;
            float angle2 = (float)(i + 1) / 180.0f * 2.0f * 3.141592f;
            if (angle1 > Math.max(target, partialAngle)) break;
            if (angle2 > Math.max(target, partialAngle)) {
                angle2 = Math.max(target, partialAngle);
            }
            float t = baseTransparency * 1.0f;
            if (angle1 > target && angle1 <= partialAngle) {
                t *= 1.0f - (angle1 - target) / (partialAngle - target);
            } else if (angle1 > partialAngle && angle1 < target) {
                t *= 1.0f - (angle1 - partialAngle) / (target - partialAngle);
            }
            this.addAnglePos(buffer, angle1, 1.0f, r, g, b, t, cx, cy, size);
            this.addAnglePos(buffer, angle1, 0.0f, r, g, b, t, cx, cy, size);
            this.addAnglePos(buffer, angle2, 0.0f, r, g, b, t, cx, cy, size);
            this.addAnglePos(buffer, angle2, 1.0f, r, g, b, t, cx, cy, size);
        }
        buffer.func_181662_b((double)(cx - size / 2), (double)(cy + size / 2), 0.0).func_187315_a(0.5, 0.5).func_181666_a(1.0f, 1.0f, 1.0f, baseTransparency).func_181675_d();
        buffer.func_181662_b((double)(cx + size / 2), (double)(cy + size / 2), 0.0).func_187315_a(1.0, 0.5).func_181666_a(1.0f, 1.0f, 1.0f, baseTransparency).func_181675_d();
        buffer.func_181662_b((double)(cx + size / 2), (double)(cy - size / 2), 0.0).func_187315_a(1.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, baseTransparency).func_181675_d();
        buffer.func_181662_b((double)(cx - size / 2), (double)(cy - size / 2), 0.0).func_187315_a(0.5, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, baseTransparency).func_181675_d();
        instance.func_78381_a();
    }

    @SideOnly(value=Side.CLIENT)
    private void addAnglePos(BufferBuilder buffer, float angle, float rad, float r, float g, float b, float a, int cx, int cy, int size) {
        float c = MathHelper.func_76134_b((float)(angle - 1.5705f));
        float s = MathHelper.func_76126_a((float)(angle - 1.5705f));
        buffer.func_181662_b((double)((float)cx + MathHelper.func_76131_a((float)(c * 0.709f * rad), (float)-0.5f, (float)0.5f) * (float)size), (double)((float)cy + MathHelper.func_76131_a((float)(s * 0.709f * rad), (float)-0.5f, (float)0.5f) * (float)size), 0.0).func_187315_a((double)MathHelper.func_76131_a((float)(64.0f + c * 92.0f * rad), (float)0.0f, (float)128.0f) / 256.0, (double)MathHelper.func_76131_a((float)(64.0f + s * 92.0f * rad), (float)0.0f, (float)128.0f) / 256.0).func_181666_a(r, g, b, a).func_181675_d();
    }

    public void handle(int progress, int max) {
        this.progress = progress;
        this.maxprogress = max;
        this.timeSinceLastUpdate = 0;
    }
}

