/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.helper;

import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;

public class NBTSerializer<T> {
    private final HashMap<String, DataTag<T, ?>> map = new HashMap();

    private NBTSerializer() {
    }

    public static <T> NBTSerializer<T> createSerializer() {
        return new NBTSerializer<T>();
    }

    @Nonnull
    public NBTTagCompound serialize(T object, @Nonnull NBTTagCompound tag) {
        this.map.forEach((key, tDataTag) -> tag.func_74782_a(key, tDataTag.write(object)));
        return tag;
    }

    public void deserialize(T object, @Nonnull NBTTagCompound tag) {
        this.map.forEach((key, datatag) -> {
            if (tag.func_74764_b(key)) {
                NBTBase base = tag.func_74781_a(key);
                datatag.read(object, base);
            }
        });
    }

    @Nonnull
    public <V, K extends NBTBase> NBTSerializer<T> add(String key, Function<T, V> getter, BiConsumer<T, V> setter, Function<V, K> toTag, Function<K, V> fromTag) {
        DataTagGetterSetter<T, V, K> tvkDataTagGetterSetter = new DataTagGetterSetter<T, V, K>(toTag, fromTag, getter, setter);
        this.map.put(key, tvkDataTagGetterSetter);
        return this;
    }

    @Nonnull
    public NBTSerializer<T> addInteger(String key, Function<T, Integer> getter, BiConsumer<T, Integer> setter) {
        return this.add(key, getter, setter, NBTTagInt::new, NBTTagInt::func_150287_d);
    }

    @Nonnull
    public NBTSerializer<T> addString(String key, Function<T, String> getter, BiConsumer<T, String> setter) {
        return this.add(key, getter, setter, NBTTagString::new, NBTTagString::func_150285_a_);
    }

    public static class DataTagGetterSetter<T, V, K extends NBTBase>
    extends DataTag<T, K> {
        public final Function<V, K> toTag;
        public final Function<K, V> fromTag;
        public final Function<T, V> getter;
        public final BiConsumer<T, V> setter;

        public DataTagGetterSetter(Function<V, K> toTag, Function<K, V> fromTag, Function<T, V> getter, BiConsumer<T, V> setter) {
            this.toTag = toTag;
            this.fromTag = fromTag;
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public void read(T object, K tag) {
            V apply = this.fromTag.apply(tag);
            this.setter.accept(object, apply);
        }

        @Override
        public K write(T object) {
            V apply = this.getter.apply(object);
            return (K)((NBTBase)this.toTag.apply(apply));
        }
    }

    public static abstract class DataTag<T, K extends NBTBase> {
        public abstract void read(T var1, K var2);

        public abstract K write(T var1);
    }
}

