/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.data;

import com.rwtema.monkmod.MonkMod;
import com.rwtema.monkmod.helper.NBTSerializer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class MonkData
implements INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    public static final ResourceLocation LOCATION = new ResourceLocation("monk", "monk_level_data");
    @Nullable
    @CapabilityInject(value=MonkData.class)
    public static final Capability<MonkData> MONKLEVELDATA = null;
    private static final NBTSerializer<MonkData> serializer = NBTSerializer.createSerializer().addInteger("level", MonkData::getLevel, MonkData::setLevel).addInteger("progress", MonkData::getProgress, MonkData::setProgress);
    public int dirty = 100;
    public boolean progressDirty = true;
    private int progress = -1;
    private int max_progress = -1;
    private int level = -1;

    @CapabilityInject(value=MonkData.class)
    public static void test(Capability<MonkData> cap) {
        MonkMod.logger.debug("Cap Registered");
    }

    public int getMaxProgress() {
        return this.max_progress;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
        this.progress = 0;
        this.max_progress = -1;
        this.progressDirty = true;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        if (progress != this.progress) {
            this.progressDirty = true;
        }
        this.progress = progress;
    }

    public NBTTagCompound serializeNBT() {
        return serializer.serialize(this, new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        serializer.deserialize(this, nbt);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == MONKLEVELDATA;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == MONKLEVELDATA ? MONKLEVELDATA.cast((Object)this) : null);
    }

    public boolean increase(int k, int threshold) {
        if (k != 0 || threshold != this.max_progress) {
            this.progressDirty = true;
        }
        this.progress += k;
        this.max_progress = threshold;
        return this.progress >= threshold;
    }

    public void resetProgress() {
        if (this.progress != 0) {
            this.progressDirty = true;
        }
        this.progress = 0;
    }
}

