/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.advancements.criteria;

import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementTick;
import com.rwtema.monkmod.data.MonkData;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.StatList;
import net.minecraft.stats.StatisticsManagerServer;

public abstract class MonkRequirementWalk
extends MonkRequirementTick {
    private static final int STEP_PER_BLOCK = 100;
    @Nonnull
    final WeakHashMap<EntityPlayerMP, MutableInt> trackers = new WeakHashMap();

    public MonkRequirementWalk(double numSteps, String name) {
        super(name, (int)(numSteps * 100.0));
    }

    @Override
    protected void doTick(@Nonnull EntityPlayerMP player, @Nonnull MonkData monkData) {
        if (this.satisfiesRequirements(player)) {
            MutableInt mutableInt = this.trackers.computeIfAbsent(player, playerMP -> new MutableInt(this.getRunDist((EntityPlayerMP)playerMP)));
            int k = mutableInt.getDiffAndStore(this.getRunDist(player));
            if (monkData.increase(k, this.requirementLimit)) {
                this.grantLevel(player);
                this.trackers.remove(player);
            }
        } else {
            monkData.resetProgress();
        }
    }

    public int getRunDist(@Nonnull EntityPlayerMP playerMP) {
        StatisticsManagerServer statFile = playerMP.func_147099_x();
        return statFile.func_77444_a(StatList.field_188102_l) + statFile.func_77444_a(StatList.field_188099_i) + statFile.func_77444_a(StatList.field_188100_j);
    }

    @Override
    @Nonnull
    protected Object[] args() {
        return new Object[]{Float.valueOf((float)this.requirementLimit / 100.0f)};
    }

    public boolean satisfiesRequirements(@Nonnull EntityPlayerMP player) {
        return MonkAbility.isUnarmored((EntityPlayer)player);
    }

    public class MutableInt {
        int value;

        public MutableInt(int value) {
            this.value = value;
        }

        public int getDiffAndStore(int newValue) {
            int diff = newValue - this.value;
            this.value = newValue;
            return diff;
        }
    }
}

