/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.abilities;

import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.abilities.MonkAbility;
import java.text.NumberFormat;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MonkAbilityJump
extends MonkAbility {
    private final double jumpLevel;

    public MonkAbilityJump(double jumpLevel) {
        super("jump");
        this.jumpLevel = jumpLevel;
    }

    @SubscribeEvent
    public void onFall(@Nonnull LivingFallEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!MonkManager.getAbilityLevel(player, this)) {
            return;
        }
        event.setDistance(event.getDistance() - 3.0f);
    }

    @SubscribeEvent
    public void onJump(@Nonnull LivingEvent.LivingJumpEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!MonkManager.getAbilityLevel(player, this)) {
            return;
        }
        player.field_70181_x *= this.jumpLevel;
    }

    @Override
    @Nonnull
    protected String[] args() {
        return new String[]{NumberFormat.getPercentInstance(Locale.UK).format(this.jumpLevel - 1.0)};
    }
}

