/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.abilities;

import com.google.common.collect.HashMultimap;
import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.factory.Factory;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public abstract class MonkAbilityAttribute
extends MonkAbility {
    public static final HashMultimap<UUID, MonkAbilityAttribute> uuids = HashMultimap.create();
    @Nonnull
    public final UUID uuid;
    public final IAttribute attribute;
    public final int operation;
    private final double multiplier;

    public MonkAbilityAttribute(@Nonnull String name, IAttribute attribute, double multiplier, int operation) {
        super(name);
        this.uuid = this.generate(name);
        this.attribute = attribute;
        this.multiplier = multiplier;
        this.operation = operation;
        if (Factory.shouldRegister) {
            uuids.put((Object)this.uuid, (Object)this);
        }
    }

    @Override
    public void tickServer(@Nonnull EntityPlayerMP player) {
        IAttributeInstance entityAttribute = player.func_110148_a(this.attribute);
        AttributeModifier modifier = entityAttribute.func_111127_a(this.uuid);
        if (this.canApply((EntityPlayer)player)) {
            double amount = this.getAmount((EntityPlayer)player);
            if (modifier == null || modifier.func_111164_d() != amount) {
                if (modifier != null) {
                    entityAttribute.func_188479_b(this.uuid);
                }
                AttributeModifier attributeModifier = new AttributeModifier(this.uuid, this.name, amount, this.operation);
                entityAttribute.func_111121_a(attributeModifier);
            }
        } else if (modifier != null) {
            entityAttribute.func_111124_b(modifier);
        }
        super.tickServer(player);
    }

    @Override
    @Nonnull
    protected String[] args() {
        return new String[]{NumberFormat.getPercentInstance(Locale.UK).format(this.multiplier)};
    }

    @Nonnull
    public UUID generate(@Nonnull String name) {
        return UUID.nameUUIDFromBytes(name.getBytes(Charset.defaultCharset()));
    }

    public double getAmount(EntityPlayer player) {
        return this.multiplier;
    }

    public abstract boolean canApply(EntityPlayer var1);
}

