/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.abilities;

import com.google.common.collect.Multimap;
import com.rwtema.monkmod.api.MonkWear;
import com.rwtema.monkmod.config.MonkConfiguration;
import com.rwtema.monkmod.factory.Factory;
import com.rwtema.monkmod.factory.IFactoryMade;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;

public abstract class MonkAbility
implements IFactoryMade {
    public static final EntityEquipmentSlot[] HELD_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND};
    public static final EntityEquipmentSlot[] ARMOR_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS};
    public static final Set<String> DAMAGE_MODIFIERS = Stream.of(SharedMonsterAttributes.field_111264_e, SharedMonsterAttributes.field_188790_f).map(IAttribute::func_111108_a).collect(Collectors.toSet());
    public static final Set<String> ARMOR_MODIFIERS = Stream.of(SharedMonsterAttributes.field_189429_h, SharedMonsterAttributes.field_188791_g).map(IAttribute::func_111108_a).collect(Collectors.toSet());
    public final String name;

    public MonkAbility(String name) {
        this.name = name;
        if (Factory.shouldRegister) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public static boolean isUnarmed(@Nonnull EntityPlayer player) {
        return MonkAbility.checkForContraband(player, HELD_SLOTS, DAMAGE_MODIFIERS);
    }

    private static boolean checkForContraband(@Nonnull EntityPlayer player, EntityEquipmentSlot[] slots, @Nonnull Set<String> illegalModifiers) {
        for (EntityEquipmentSlot slot : slots) {
            Item item;
            Multimap itemAttributeModifiers;
            ResourceLocation registryName;
            ItemStack itemStack = player.func_184582_a(slot);
            if (itemStack.func_190926_b() || MonkConfiguration.whitelist.contains(registryName = itemStack.func_77973_b().getRegistryName())) continue;
            if (MonkConfiguration.blacklist.contains(registryName)) {
                return false;
            }
            if (itemStack.hasCapability(MonkWear.MONK_SAFE_CAPABILITY, null)) {
                MonkWear capability = (MonkWear)itemStack.getCapability(MonkWear.MONK_SAFE_CAPABILITY, null);
                assert (capability != null);
                if (!capability.canMonkWear(player)) {
                    return false;
                }
            }
            if ((itemAttributeModifiers = (item = itemStack.func_77973_b()).getAttributeModifiers(slot, itemStack)).isEmpty()) continue;
            if (!illegalModifiers.stream().anyMatch(arg_0 -> ((Multimap)itemAttributeModifiers).containsKey(arg_0))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnarmored(@Nonnull EntityPlayer player) {
        return MonkAbility.checkForContraband(player, ARMOR_SLOTS, ARMOR_MODIFIERS);
    }

    public void tickServer(EntityPlayerMP player) {
    }

    public String getUnlocalized() {
        return "monk.advancements.ability." + this.name;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Nonnull
    public ITextComponent getTextComponent() {
        TextComponentTranslation iTextComponents = new TextComponentTranslation(this.getUnlocalized(), new Object[0]);
        iTextComponents.func_150256_b().func_150238_a(TextFormatting.AQUA);
        ITextComponent textComponent = new TextComponentString(": ").func_150257_a((ITextComponent)new TextComponentTranslation(this.getUnlocalized() + ".desc", (Object[])this.args()));
        textComponent.func_150256_b().func_150238_a(TextFormatting.RESET);
        return iTextComponents.func_150257_a(textComponent);
    }

    protected String[] args() {
        return new String[0];
    }
}

